#include "calendarlistmodel.h"
#include <CCalendar.h>
#include <iostream>

using namespace std;

CalendarListModel::CalendarListModel()
{
}

QVariant CalendarListModel::data(const QModelIndex &item, int role) const {
    //cout << "data() [" << item.row() << "," << item.column() << "] role " << role << endl;

    QVariant data = QSqlQueryModel::data(item,role); //process data from parent first

    if(role == Qt::DisplayRole){
        switch(item.column()){
        case 1: //Calendar Name
            return QVariant(resolveCalendarName(data.toString()));
            break;
        case 2: //Calendar Color pixmap path
            return QVariant(resolveCalendarIcon(data.toInt()));
            break;
        case 4: //Calendar Type
            return QVariant(resolveCalendarType(data.toInt()));
            break;
        }
    }

    return data; //return default data from parent class
}

QString CalendarListModel::resolveCalendarName(QString calendarName) const {
    if(calendarName == "cal_ti_calendar_synced"){
        return "Main Device Calendar";
    }

    if(calendarName == "cal_ti_calendar_private"){
        return "Private";
    }

    return calendarName;
}

QString CalendarListModel::resolveCalendarType(int type) const {
    QString text("Unknown Type");

    switch (type){
    case LOCAL_CALENDAR:
        text = "Local";
        break;
    case BIRTHDAY_CALENDAR:
        text = "Smart Birthdays";
        break;
    case SYNC_CALENDAR:
        text = "Sync";
        break;
    case DEFAULT_PRIVATE:
        text = "Default Private";
        break;
    case DEFAULT_SYNC:
        text = "Default Sync";
        break;
    default:
        break;
    }

    return text.append(")").prepend("(");
}

/*
 * Returns the full pixmap path for the calendar color icon
 */
QString CalendarListModel::resolveCalendarIcon(int color) const {
    bool image = true;
    QString iconPath("/usr/share/icons/hicolor/48x48/hildon/");
    switch (color) {
    case COLOUR_DARKBLUE:
        iconPath.append("calendar_colors_darkblue");
        break;

    case COLOUR_DARKGREEN:
        iconPath.append("calendar_colors_darkgreen");
        break;

    case COLOUR_DARKRED:
        iconPath.append("calendar_colors_darkred");
        break;

    case COLOUR_ORANGE:
        iconPath.append("calendar_colors_orange");
        break;

    case COLOUR_VIOLET:
        iconPath.append("calendar_colors_violet");
        break;

    case COLOUR_YELLOW:
        iconPath.append("calendar_colors_yellow");
        break;

    case COLOUR_WHITE:
        iconPath.append("calendar_colors_white");
        break;

    case COLOUR_BLUE:
        iconPath.append("calendar_colors_blue");
        break;

    case COLOUR_RED:
        iconPath.append("calendar_colors_red");
        break;

    case COLOUR_GREEN:
        iconPath.append("calendar_colors_green");
        break;

    default:
        image = false;
    }

    if (image){
        iconPath.append(".png");
    } else {
        iconPath.clear();
    }
    //cout << "iconPath:" << iconPath.toLocal8Bit().constData() << endl;
    return iconPath;

}
