#include "calendarlistitemdelegate.h"
#include "calendarlistitem.h"
#include <QApplication>
#include <QPainter>
#include <QStyleOptionProgressBar>
#include <iostream>

using namespace std;

CalendarListItemDelegate::CalendarListItemDelegate(QObject *parent) :
        QStyledItemDelegate(parent)
{
    this->li = new CalendarListItem();
}

CalendarListItemDelegate::~CalendarListItemDelegate(){
    delete this->li;
}

void CalendarListItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const{

        this->li->resize(option.rect.size());

        painter->save();

        QStyledItemDelegate::paint(painter, option, index); //paint parent

        painter->translate(option.rect.topLeft());
        this->li->setSummary(index.sibling(index.row(),1).data().toString());
        this->li->setSubtitle(index.sibling(index.row(),4).data().toString());
        this->li->setIcon(index.sibling(index.row(),2).data().toString());
        this->li->render(painter,QPoint(),QRegion(), QWidget::DrawChildren); //autofill off so we get default paint effects below
        //this->li->render(painter);

//        CalendarListItem li;
//        //QRect rect = QRect(option.rect.left(),option.rect.right(),option.rect.width(),option.rect.height());
//        //li.render(painter,option.rect.bottomLeft());

/* SAMPLE CODE */
//        QStyleOptionProgressBar progressBarOption;
//        progressBarOption.rect = option.rect;
//        progressBarOption.minimum = 0;
//        progressBarOption.maximum = 100;
//        progressBarOption.progress = 55;
//        progressBarOption.text = QString::number(55) + "%";
//        progressBarOption.textVisible = true;
//        QApplication::style()->drawControl(QStyle::CE_ProgressBar,&progressBarOption,painter);
/***************/
        painter->restore();

}
