
#include "calendarcomponentlistwidget.h"
#include "ui_calendarcomponentlistwidget.h"
#include "taskviewfolderitem.h"
#include "taskviewitemwidget.h"
#include "taskviewtaskitem.h"
#include "taskviewnoteitem.h"
#include "folder.h"
#include "db.h"
#include <calendar-backend/CalendarErrors.h>
#include <calendar-backend/CMulticalendar.h>
#include <calendar-backend/CComponent.h>
#include <calendar-backend/CTodo.h>
#include <calendar-backend/CCalendar.h>
#include <calendar-backend/CJournal.h>
#include <calendar-backend/CAlarm.h>
#include <QDateTime>
#include <QLocale>

#include <iostream>
using namespace std;

CalendarComponentListWidget::CalendarComponentListWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::CalendarComponentListWidget)
{
    ui->setupUi(this);
    this->componentId = 0;
    this->componentType = 0;
}

CalendarComponentListWidget::~CalendarComponentListWidget()
{
    delete ui;
}

void CalendarComponentListWidget::setComponentId(int Id){
    this->componentId = Id;
}

int CalendarComponentListWidget::getComponentId(){
    return this->componentId;
}

void CalendarComponentListWidget::setComponentType(int Type){
    this->componentType = Type;
}

int CalendarComponentListWidget::getComponentType(){
    return this->componentType;
}

void CalendarComponentListWidget::renderComponent(){

    cout << "from listwidget type is" << this->componentType << endl;
    switch(this->componentType){
    case 0:{
        renderFolder();
        break;
    }
    case 2:{
        renderTask();
        break;
    }
    case 3:{
        renderNote();
        break;
    }
    }

}

void CalendarComponentListWidget::renderFolder(){

    //load the class that represents the folder item.  this will cause lots of selects, but can optimize code later
    int error_code = 0;
    Folder* f = DB::getFolder(this->componentId, error_code);
    if (error_code == CALENDAR_OPERATION_SUCCESSFUL) {
        TaskViewFolderItem* w = new TaskViewFolderItem(this);
        ui->layout->addWidget(w);
        w->setFolderName(f->getName());
    }
    delete f;
}

void CalendarComponentListWidget::renderTask(){
    TaskViewTaskItem* w = new TaskViewTaskItem(this);
    ui->layout->addWidget(w);
    QString id= QString::number(this->componentId);

    int error_code = 0;
    int cal_id = CMulticalendar::MCInstance()->getCalendarIdForComponent
            (id.toLocal8Bit().constData(), error_code);
    if(error_code != CALENDAR_OPERATION_SUCCESSFUL || cal_id == 0){
        if(cal_id == 0) {
            w->setSummary("Error retrieving Calendar ID");
        }
    }

    CCalendar* calendar = CMulticalendar::MCInstance()->getCalendarById(cal_id, error_code);
    if (!calendar){
        w->setSummary("Error retrieving Calendar");
    }
    CTodo* todo = calendar->getTodo(id.toLocal8Bit().constData(),error_code);
    if (!todo){
        w->setSummary("Error retrieving Task");
    } else {
        w->setSummary(QString(todo->getSummary().c_str()));
    }

    QDateTime qdtDuedate;
    qdtDuedate.setTime_t(todo->getDue());
    w->setDueDate(qdtDuedate);
    w->setCalendarIcon(resolveCalendarIcon(calendar->getCalendarColor()));
    w->setPriorityIcon(resolvePriorityIcon(todo->getPriority()));
    cout << "get complete:" << todo->getCompleted() << endl;
    cout << "get status" << todo->getStatus() << endl;
    if(!todo->getStatus()){
        w->setUrgencyIcon(resolveUrgencyIcon(qdtDuedate));
    }

    CComponent* component = todo;
    CAlarm* alarm = component->getAlarm();
    bool has_alarm = false;
    if(alarm){
        has_alarm = true;
    }
    w->setToggleAlarm(has_alarm);

    QString description = todo->getDescription().c_str();
    bool has_attachment = false;
    if(description.length() > 0){
        has_attachment = true;
    }
    w->setToggleAttachment(has_attachment);

    delete calendar;
    delete todo;

}

void CalendarComponentListWidget::renderNote(){
    cout <<"rendering note:" << endl;
    TaskViewNoteItem* w = new TaskViewNoteItem(this);
    ui->layout->addWidget(w);

    QString id= QString::number(this->componentId);
    int error_code = 0;

    int cal_id = CMulticalendar::MCInstance()->getCalendarIdForComponent
            (id.toLocal8Bit().constData(), error_code);
    if(error_code != CALENDAR_OPERATION_SUCCESSFUL || cal_id == 0){
            w->setSummary("Error retrieving Note");
            return;
    }

    CCalendar* calendar = CMulticalendar::MCInstance()->getCalendarById(cal_id, error_code);
    CJournal* journal = calendar->getJournal(id.toLocal8Bit().constData(),error_code);

    QDateTime qdtDateStamp;
    qdtDateStamp.setTime_t(journal->getLastModified());
    QString summary(journal->getSummary().c_str());
    w->setSummary(summary.simplified());
    w->setUpdatedDate(qdtDateStamp);

    delete calendar;
    delete journal;
}

QString CalendarComponentListWidget::resolveUrgencyIcon(QDateTime DueDate) const{
    QString iconPath("/usr/share/icons/hicolor/48x48/hildon/");

    int daysDue = QDateTime::currentDateTime().daysTo(DueDate);

    if(daysDue < 0)  {
    //late
        iconPath.append("statusarea_presence_busy_error.png");
        return iconPath;
    }

    if(daysDue == 0){
        //due today
        iconPath.append("statusarea_presence_away_error.png");
        return iconPath;
    }

    if(daysDue ==1 ){
        //due tomorrow
      iconPath.append("statusarea_presence_online_error.png");
       return iconPath;
    }
    //iconPath.append("statusarea_presence_online_error.png");
    return "/usr/share/icons/hicolor/16x16/hildon/calendar_todo.png";

}

QString CalendarComponentListWidget::resolvePriorityIcon(int Priority) const {
    QString iconPath("/usr/share/icons/hicolor/scalable/hildon/statusarea_cell_level");
    iconPath.append(QString::number(Priority));
    iconPath.append(".png");
    return iconPath;
}

QString CalendarComponentListWidget::resolveCalendarIcon(int color) const {
    bool image = true;
    QString iconPath("/usr/share/icons/hicolor/48x48/hildon/");
    switch (color) {
    case COLOUR_DARKBLUE:
        iconPath.append("calendar_colors_darkblue");
        break;

    case COLOUR_DARKGREEN:
        iconPath.append("calendar_colors_darkgreen");
        break;

    case COLOUR_DARKRED:
        iconPath.append("calendar_colors_darkred");
        break;

    case COLOUR_ORANGE:
        iconPath.append("calendar_colors_orange");
        break;

    case COLOUR_VIOLET:
        iconPath.append("calendar_colors_violet");
        break;

    case COLOUR_YELLOW:
        iconPath.append("calendar_colors_yellow");
        break;

    case COLOUR_WHITE:
        iconPath.append("calendar_colors_white");
        break;

    case COLOUR_BLUE:
        iconPath.append("calendar_colors_blue");
        break;

    case COLOUR_RED:
        iconPath.append("calendar_colors_red");
        break;

    case COLOUR_GREEN:
        iconPath.append("calendar_colors_green");
        break;

    default:
        image = false;
    }

    if (image){
        iconPath.append(".png");
    } else {
        iconPath.clear();
    }
    //cout << "iconPath:" << iconPath.toLocal8Bit().constData() << endl;
    return iconPath;

}
