# -*- coding: utf-8 -*-

__author__= "Michael Wong"
__email__="imichaelwong@gmail.com"
__version__= "0.1.0"
__build__="110101"

import platform
import sys
import string
import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *
import Utils
#from PyQt4.QtMaemo5 import *
#from flickcharm import *
from PyQt4.QtGui import *

class WebsitesModel(QAbstractListModel):
    def __init__(self, websites=None, parent=None):
        super(WebsitesModel, self).__init__(parent)
        self.websites=websites

    def rowCount(self,parent=None):
        return len(self.websites)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return None
        if (index.row() >= len(self.websites)):
            return None
        if (role == Qt.DisplayRole):
            website=self.websites[index.row()]
            source="""
            <tr style="font-size:22px;color:#FFFFFF">
                <td>%s</td>
                <td align="left">%s</td>
            </tr>
            </table>
            """
            html="<table width=\"80%\" border=\"0\">"+source % (unicode(website["name"]), website["indexUrl"])
            return html
        else:
            return self.websites[index.row()]

class AccountsModel(QAbstractListModel):
    def __init__(self,accounts=None,websites=None, parent=None):
        super(AccountsModel, self).__init__(parent)
        self.accounts=accounts
        self.websites=websites


    def rowCount(self,parent=None):
        return len(self.accounts)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return None
        if (index.row() >= len(self.accounts)):
            return None
        if (role == Qt.DisplayRole):
            account=self.accounts[index.row()]
            username=account["nickname"]
            return username
        if (role==Utils.ROLE_AVATAR):
            account=self.accounts[index.row()]
            website=None
            for web in self.websites:
                if web["id"]==account["website"]:
                    website=web
                    break
            icon=Utils.ICONS_DIR+website["icon"]
            return icon
        else:
            return self.accounts[index.row()]["id"]

class MenusModel(QAbstractListModel):
    def __init__(self,menus=None, parent=None):
        super(MenusModel, self).__init__(parent)
        self.menus=menus


    def rowCount(self,parent=None):
        return len(self.menus)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return None
        if (index.row() >= len(self.menus)):
            return None
        if (role == Qt.DisplayRole):
            menu=self.menus[index.row()]["name"]
#            html=self.makeMenuHtml(menu)
            return menu
        if (role==Utils.ROLE_AVATAR):
            return self.menus[index.row()]["icon"]
        else:
            return self.menus[index.row()]["value"]


class StatusModel(QAbstractListModel):
    def __init__(self, statuses=None, parent=None):
        super(StatusModel, self).__init__(parent)
        self.statuses=statuses

    def rowCount(self,parent=None):
        return len(self.statuses)

    def data(self,index,role= Qt.DisplayRole):
        status=self.statuses[index.row()]
        #test if an operation
        if (role==Utils.ROLE_TEST_OPERATION):
            try:
                type=status["type"]
                return True
            except KeyError,ke:
                return False
        #test if a gap
        if (role==Utils.ROLE_TEST_GAP):
            if status["if_gap"]:
                return True
            else:
                return False

        #it is an operation
        if (role==Utils.ROLE_OPERATION):
            #it is an operation
            name=status["name"]
            lastUpdated=status["lastUpdated"]
            if lastUpdated!=None:
                return name+"\nLast updated at: "+lastUpdated
            else:
                return name

        #it is a status

        if (role==Utils.ROLE_ID):
            #print "status -> id:"
            #print status["id"]
            
            return status["status_id"]
        if (role == Qt.DisplayRole):
            return status["text"]

        if (role == Utils.ROLE_AVATAR):
            user=status["user"]
            userImage=Utils.AVATAR_DIR+str(status["account"])+"_"+str(user["id"])
            if platform.os.access(userImage, platform.os.W_OK) == 0:
                userImage=Utils.DEFAULT_AVATAR_FILE
            return userImage
        if (role == Utils.ROLE_NAME):
            user=status["user"]
            return user["name"]
        if (role == Utils.ROLE_TIME):
            createdAt=status["created_at"]
            time=Utils.gene_datetime_string(createdAt)
            return time
        if (role == Utils.ROLE_THUMBNAIL):
            thumbnailPic=status["thumbnail_pic"]
            
            if thumbnailPic!=None:
                filename=thumbnailPic.split("/")[-1]
                if len(filename)==0 or filename=="460":
                    filename=thumbnailPic.split("/")[-2]
                    
                thumbnailPic=Utils.THUMBNAIL_DIR+str(status["account"])+"_"+str(status["id"])+"_"+filename
                if os.access(thumbnailPic, platform.os.W_OK) == 0:
                    thumbnailPic=None
            return thumbnailPic

        rt=None
        rtUser=None
        rtName=None
        rtText=None
        rtThumbnailPic=None
        try:
            rt=status["retweeted_status"]
        except KeyError,ke:
            return
	
        if rt!=None:
        
	    #print "debug rt:"
	    #print rt
	
            rtUser=rt["user"]
            rtName=rtUser["name"]
            rtText=rt["text"]
            rtUserImage=Utils.AVATAR_DIR+str(status["account"])+"_"+str(rtUser["id"])
            if platform.os.access(rtUserImage, platform.os.W_OK) == 0:
                rtUserImage=Utils.DEFAULT_AVATAR_FILE
            rtThumbnailPic=rt["thumbnail_pic"]
            if rtThumbnailPic!=None:
                filename=rtThumbnailPic.split("/")[-1]
                rtThumbnailPic=Utils.THUMBNAIL_DIR+str(status["account"])+"_"+str(rt["id"])+"_"+filename
                if os.access(rtThumbnailPic, platform.os.W_OK) == 0:
                    rtThumbnailPic=None
        if (role == Utils.ROLE_RT_NAME):
            return rtName
        if (role == Utils.ROLE_RT_TEXT):
            return rtText
        if (role == Utils.ROLE_RT_AVATAR):
            return rtUserImage
        if (role == Utils.ROLE_RT_THUMBNAIL):
            return rtThumbnailPic


  
