# -*- coding: utf-8 -*-


__author__="Michael/Binkcn"
__date__ ="$2011-09-04$"

import sys
import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
import logging
from datetime import datetime
from UI import *
from Controller import Controller
#from Updater import *
from UpdaterSina import *
from UpdaterQQ import *
from weibopy.error import WeibopError
#from qqweibo.error import QWeiboError
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from flickcharm import FlickCharm

class MaoboApp(QApplication):
    def __init__(self, parent=None):
        self.logger = logging.getLogger('maebo')
        self.logger.info("__initing__")
        super(MaoboApp, self).__init__(parent)
        self.charm = FlickCharm()
        self.controller=Controller()
        
        #self.updater=Updater(self.show_notice)
        #self.sender=Sender(self.show_notice)
        
        self.updatersina=UpdaterSina(self.show_notice)
        self.sendersina=SenderSina(self.show_notice)
        self.updaterqq=UpdaterQQ(self.show_notice)
        self.senderqq=SenderQQ(self.show_notice)
        
        #self.connect(self.updater, SIGNAL("finished(bool)"), self.update_finished)
        #self.connect(self.sender, SIGNAL("finished(bool)"), self.send_finished)
        #self.connect(self.updater, SIGNAL("show_notice(QString,int)"), self.show_notice)
        #self.connect(self.sender, SIGNAL("show_notice(QString,int)"), self.show_notice)
        
        self.connect(self.updatersina, SIGNAL("finished(bool)"), self.update_finished)
        self.connect(self.sendersina, SIGNAL("finished(bool)"), self.send_finished)
        self.connect(self.updatersina, SIGNAL("show_notice(QString,int)"), self.show_notice)
        self.connect(self.sendersina, SIGNAL("show_notice(QString,int)"), self.show_notice)
        
        self.connect(self.updaterqq, SIGNAL("finished(bool)"), self.update_finished)
        self.connect(self.senderqq, SIGNAL("finished(bool)"), self.send_finished)
        self.connect(self.updaterqq, SIGNAL("show_notice(QString,int)"), self.show_notice)
        self.connect(self.senderqq, SIGNAL("show_notice(QString,int)"), self.show_notice)
        
        self.currentStatus=None
        self.timelineType=None
        self.accounts=self.controller.get_all_accounts()
        self.websites=self.controller.get_all_websites()
        self.currentAccount=None

        self.create_accounts_window()
        self.create_menus_window()
        self.create_timeline_window()
        self.create_status_window()
        self.newStatusWin=None
        self.accountsManaForm=None
        self.newAccountForm=None

        self.accountsWin.show()


    def create_accounts_window(self):
        self.accountsWin=AccountsWindow(None,self.accounts,self.websites)
        self.connect(self.accountsWin.accountsListView,
                     SIGNAL("clicked(const QModelIndex&)"),
                     self.account_clicked)
        accountsManaAction = self.create_action(unicode("账户管理"), self.show_accounts_mana_form)
        aboutAction=self.create_action(unicode("关于"), self.show_about_form)
        self.menuBar=QMenuBar()
        self.add_actions(self.menuBar, (accountsManaAction,aboutAction))
        self.accountsWin.setMenuBar(self.menuBar)

    def account_clicked(self,index):
        self.logger.debug("account_clicked")
        row=index.row()
        self.currentAccount=self.accounts[row]
        print self.currentAccount
        
        if self.currentAccount["website"]==1:
            self.updater=self.updatersina
            self.sender=self.sendersina
        else:
            self.updater=self.updaterqq
            self.sender=self.senderqq
        
	try:
	    self.updater.OAuth(self.currentAccount["username"],self.currentAccount["password"])
	    self.sender.OAuth(self.currentAccount["username"],self.currentAccount["password"])
	except WeibopError,we:
	    self.show_notice(we)
        
        self.logger.debug(self.currentAccount["username"]+" choosed.")
        self.menusWin.show()

    def create_menus_window(self):
        self.menus=Utils.build_menus()
        self.menusWin=MenusWindow(self.accountsWin,self.menus)

        self.connect(self.menusWin.menuListView,
                     SIGNAL("clicked(const QModelIndex&)"),
                     self.menu_clicked)


    def menu_clicked(self,index):
        self.logger.debug("menu_clicked")
        row=index.row()
        menu=self.menus[row]
        self.logger.debug(menu["name"]+" choosed.")
        value=menu["value"]
        
        if value==Utils.NEW_A_STATUS:
            self.show_new_status_window()
        #elif value==Utils.TIMELINE_TYPE_DM:
        #    self.show_notice("私信功能由于官方权限限制，暂不开放。")
        else:
            self.timelineType=value
            self.show_timeline_window()

    def create_timeline_window(self):
        self.timelineWin=TimelineWindow(self.menusWin)
        self.connect(self.timelineWin.statusesListView,
                     SIGNAL("clicked(const QModelIndex&)"),
                     self.status_clicked)
        self.updateOpe=Utils.build_an_operation(Utils.STATUS_OPE_TYPE_UPDATE,
                                          "Click to update",
                                          Utils.get_last_update_time_by_timeline_type(self.currentAccount,self.timelineType))
        self.moreOpe=Utils.build_an_operation(Utils.STATUS_OPE_TYPE_MORE,
                                        "Click to load more",None)
        self.gapOpe=Utils.build_an_operation(Utils.STATUS_OPE_TYPE_GAP,
                                        "Click to eliminate the gap",None)
        self.currentOpe=None

    def create_status_window(self):
        self.statusWin=StatusWindow(self.timelineWin)
        self.connect(self.statusWin.rtBtn, SIGNAL("clicked()"), self.rt_a_status)
        self.connect(self.statusWin.cmtBtn, SIGNAL("clicked()"), self.comment_a_status)
        self.connect(self.statusWin.dmBtn, SIGNAL("clicked()"), self.dm_a_status)
        self.connect(self.statusWin.favBtn, SIGNAL("clicked()"), self.fav_a_status)
        self.charm.activateOn(self.statusWin.statusContentView)

    def show_timeline_window(self):
        self.logger.debug("show_timeline_window")
#        self.currentAccountId=self.accounts[0]["id"]
        self.updateOpe["lastUpdated"]=Utils.get_last_update_time_by_timeline_type(self.currentAccount,self.timelineType)
        if self.timelineType==Utils.TIMELINE_TYPE_FAVOUR:
            self.logger.debug("load favorited statuses from db")
            self.statuses=self.controller.get_favorited_statuses_by_account(self.currentAccount["id"])
        else:
            self.statuses=self.controller.get_statuses_by_account(self.currentAccount["id"],self.timelineType)
#        statusCount=self.controller.get_status_count_by_account(1)
        if len(self.statuses)>0:
            #if the last one is a gap,remove it.
            lastOne=self.statuses[-1]
            if lastOne["if_gap"]==1:
                self.logger.debug("remove the gap because it is the last one.")
                self.statuses.remove(lastOne)
            #don't provide loadmore for favorite timeline
            if self.timelineType!=Utils.TIMELINE_TYPE_FAVOUR:
                self.statuses.append(self.moreOpe)
        #don't provide update for favorite timeline
        if self.timelineType!=Utils.TIMELINE_TYPE_FAVOUR:
            self.statuses.insert(0,self.updateOpe)
        self.timelineWin.load_statuses(self.statuses)
        self.timelineWin.statusesListView.scrollToTop()
        self.timelineWin.show()

    def status_clicked(self,index):
        self.logger.debug("status_clicked")
        row=index.row()
        status=self.statuses[row]

        try:
            type=status["type"]
            self.logger.debug("type:"+str(type))
            if type==Utils.STATUS_OPE_TYPE_UPDATE:
                self.update_timeline()
            elif type==Utils.STATUS_OPE_TYPE_MORE:
                self.load_more_timeline()
        except KeyError,ae:
            if status["if_gap"]==1:
                self.logger.debug("it is a gap")
                #if it is a gap, need to fetch statuses to fill it.
                if self.updater.isRunning():
                    self.logger.debug("updater is running!")
                    self.show_notice("后台运行中，请稍候重试")
                    return
                        
                        
                if self.currentAccount["website"]==1:
                    maxStatus=self.statuses[row-1]
                    sinceStatus=self.statuses[row+1]
                    maxId=maxStatus["id"]
                    sinceId=sinceStatus["id"]
                    self.currentOpe=self.gapOpe
                    self.gapRow=row
                    self.updater.initialize(self.currentAccount["id"],self.timelineType,sinceId,maxId)
                else:
                    tmpStatus=self.statuses[row+1]
                    pagetime=tmpStatus["bmiddle_pic"]
                    self.currentOpe=self.gapOpe
                    self.gapRow=row
                    self.updater.initialize(self.currentAccount["id"],self.timelineType,2,pagetime,1)
                
#                try:
#                    self.updater.basicAuth(Utils.APP_KEY,self.currentAccount["username"],self.currentAccount["password"])
#                except WeibopError,we:
#                    self.show_notice(we)
                self.show_notice("更新中...")
                self.set_windows_status(1)
                self.updater.start()
                
            else:
                self.logger.debug("show it")
                #so just show the status
                self.currentStatus=status
                self.show_status_window(status)
        


    def update_timeline(self):
        self.logger.debug("update_fridends_timeline")
        if self.updater.isRunning():
            self.logger.debug("updater is running!")
            self.show_notice("后台运行中，请稍候重试")
            return
        self.updateOpe["name"]="updating, please wait"
        self.updateOpe["lastUpdated"]=None
        self.timelineWin.load_statuses(self.statuses)
        self.currentOpe=self.updateOpe
        
        if self.currentAccount["website"]==1:
            sinceId=None
            if len(self.statuses)>1:
                latestStatus=self.statuses[1]
                sinceId=latestStatus["id"]
                self.logger.debug("sinceId:"+str(sinceId))
            
            self.updater.initialize(self.currentAccount["id"],self.timelineType,sinceId,None)
        else:
    	    pageflag=0
    	    pagetime=0
    	    
    	    if len(self.statuses)>1:
    	        latestStatus=self.statuses[1]
    	        lasetime=int(latestStatus["bmiddle_pic"])
    	        
    	        import time
    	        nowtime = int(time.time())
    	        timediff = nowtime - lasetime
    	        if timediff <= 86400:
    	            pageflag=2
    	            pagetime=lasetime
    	            
            self.updater.initialize(self.currentAccount["id"],self.timelineType,pageflag,pagetime,10)
        
#        try:
#            self.updater.basicAuth(Utils.APP_KEY,self.currentAccount["username"],self.currentAccount["password"])
#        except WeibopError,we:
#            self.show_notice(we)
        self.show_notice("更新中...")
        self.set_windows_status(1)
        self.updater.start()
        

    def update_finished(self,completed):
        self.logger.debug("update_finished")
        self.set_windows_status(0)
        newStatuses=self.updater.timeline

        if self.currentOpe==self.updateOpe:
            #update the lastUpdateTime for the updateOpe and account
            now=datetime.now()
            self.currentAccount=Utils.set_last_update_time_by_timeline_type(self.currentAccount, self.timelineType, now)
            self.controller.save_an_account(self.currentAccount)
            self.updateOpe["name"]="Click to update"
            self.updateOpe["lastUpdated"]=Utils.get_last_update_time_by_timeline_type(self.currentAccount,
                                                                                  self.timelineType)
        elif self.currentOpe==self.moreOpe:
            self.moreOpe["name"]="Click to load more"
        
        if newStatuses!=None and len(newStatuses)>0:
            if self.currentOpe==self.updateOpe:
                self.statuses.remove(self.updateOpe)

                if len(newStatuses)==20 and len(self.statuses)>1:
                    self.logger.debug("add a gap status")
                    gapStatus=Utils.build_a_gap_status(self.currentAccount["id"])
                    gapStatus["id"]=newStatuses[-1]["id"]-1
                    newStatuses.append(gapStatus)

                self.controller.save_statuses(self.currentAccount["id"],newStatuses,self.timelineType)

                if len(self.statuses)==0:
                    self.logger.debug("add the loadMore operation to the end")
                    self.statuses.append(self.moreOpe)

                newStatuses.extend(self.statuses)
                self.statuses=newStatuses

                self.statuses.insert(0,self.updateOpe)
                self.timelineWin.load_statuses(self.statuses)
            elif self.currentOpe==self.moreOpe:
                repeatOne=newStatuses[0]
                newStatuses.remove(repeatOne)
                if len(newStatuses)>0:
                    self.controller.save_statuses(self.currentAccount["id"],newStatuses,self.timelineType)
                    self.statuses.remove(self.moreOpe)
                    self.statuses.extend(newStatuses)
                    self.statuses.append(self.moreOpe)
                    self.timelineWin.load_statuses(self.statuses)
            elif self.currentOpe==self.gapOpe:
                #there must be a repeat one:maxId, remove it.
                repeatOne=newStatuses[0]
                newStatuses.remove(repeatOne)
#                if len(newStatuses)>0:
                #first remove the old gap
                row=self.gapRow
                gapStatus=self.statuses[row]
                print "a"
                print row
                print gapStatus
                self.controller.del_status_by_id(1,gapStatus["id"])
                if len(newStatuses)==20-1:
                    #if the len is 20,maybe there are more statuses, so need a gap here.
                    self.logger.debug("add a gap status")
                    newGapStatus=Utils.build_a_gap_status(self.currentAccount["id"])
                    newGapStatus["id"]=newStatuses[-1]["id"]-1
                    newStatuses.append(newGapStatus)
                self.controller.save_statuses(self.currentAccount["id"],newStatuses,self.timelineType)

                #remove the old gap and insert the new ones into the gap.
                self.statuses.remove(gapStatus)
                i=-1
                for newOne in newStatuses:
                    i+=1
                    self.statuses.insert(row+i,newOne)
                self.timelineWin.load_statuses(self.statuses)

                        
        self.currentOpe=None

    def load_more_timeline(self):
        self.logger.debug("load_more_timeline")
        oldestStatus=self.statuses[-2]
        pagetime=oldestStatus["created_at"]
        moreStatuses=self.controller.get_statuses_by_account_qq(self.currentAccount["id"],self.timelineType,1,pagetime)
        self.logger.debug(moreStatuses)
        #if there are no older statuses in db, need to fetch from server.

        if len(moreStatuses)==0:
            #for favorite page, do not fetch from server.
            if self.timelineType==Utils.TIMELINE_TYPE_FAVOUR:
                return
            if self.updater.isRunning():
                self.logger.debug("updater is running!")
                self.show_notice("后台运行中，请稍候重试")
                return
            self.moreOpe["name"]="loading, please wait"
            self.currentOpe=self.moreOpe
            self.timelineWin.load_statuses(self.statuses)
            
            if self.currentAccount["website"]==1:
                oldestStatus=self.statuses[-2]
                maxId=oldestStatus["id"]
                self.logger.debug("maxId:"+str(maxId))
                self.updater.initialize(self.currentAccount["id"],self.timelineType,None,maxId)
            else:
                oldestStatus=self.statuses[-2]
                pagetime=oldestStatus["bmiddle_pic"]
    	        pageflag=1
        	    
                self.updater.initialize(self.currentAccount["id"],self.timelineType,pageflag,pagetime,10)
            
            
#            try:
#                self.updater.basicAuth(Utils.APP_KEY,self.currentAccount["username"],self.currentAccount["password"])
#            except WeibopError,we:
#                self.show_notice(we)
            self.show_notice("更新中...")
            self.set_windows_status(1)
            self.updater.start()
        #just load the statuses from db
        else:
            #if the last one is a gap,remove it.
            lastOne=moreStatuses[-1]
            if lastOne["if_gap"]==1:
                moreStatuses.remove(lastOne)
            moreOpe=self.statuses[-1]
            self.statuses.remove(moreOpe)
            self.statuses.extend(moreStatuses)
            self.statuses.append(moreOpe)
            self.timelineWin.load_statuses(self.statuses)


    def load_more_timeline_favorite(self):
        pass

    def show_status_window(self,status):
        self.statusWin.load_status(status)
        self.statusWin.show()

    def create_new_status_window(self,parent):
        self.newStatusWin=NewStatusWindow(parent)
        self.connect(self.newStatusWin.sendBtn,
                     SIGNAL("clicked()"),
                     self.send_a_status)

    def show_new_status_window(self,status=None):
        self.create_new_status_window(self.menusWin)
        self.newStatusWin.load_status()
        self.newStatusWin.show()

    def rt_a_status(self):
        self.create_new_status_window(self.statusWin)
        self.newStatusWin.load_status(self.currentStatus,Utils.TIMELINE_TYPE_MENTIONS)
        self.newStatusWin.show()

    def comment_a_status(self):
        self.create_new_status_window(self.statusWin)
        self.newStatusWin.load_status(self.currentStatus,Utils.TIMELINE_TYPE_COMMENTS)
        self.newStatusWin.show()

    def dm_a_status(self):
        self.create_new_status_window(self.statusWin)
        self.newStatusWin.load_status(self.currentStatus,Utils.TIMELINE_TYPE_DM)
        self.newStatusWin.show()

    def fav_a_status(self):
        #just fav it locally!!!
        favorited=self.currentStatus["favorited"]
        if favorited==None:
            favorited=0
        fav=1-favorited
        self.controller.favour_a_status(self.currentAccount["id"],self.currentStatus,fav)
        self.currentStatus["favorited"]=fav
        self.statusWin.change_favBtn_text(fav)

    def send_a_status(self):
        self.logger.debug("send_a_status")
        param=self.newStatusWin.output_param()
        if self.sender.isRunning():
            self.logger.debug("sender is running!")
            self.show_notice("后台运行中，请稍候重试")
            return
        self.newStatusWin.enable_send(False)
        self.sender.initialize(self.currentAccount["id"],param)

        self.show_notice("微博发送中...")
        self.set_windows_status(1)
        self.sender.start()

    def send_finished(self,completed):
        self.logger.debug("send_finished")
        self.set_windows_status(0)
        self.newStatusWin.enable_send(True)
        if completed:
            self.show_notice("微博已成功发送",0)
#            self.newStatusWin.hide()


    def create_accounts_mana_form(self,accounts):
        self.accountsManaForm=AccountsManaForm(accounts,self.websites,self.accountsWin)
        self.connect(self.accountsManaForm.addButton,
                     SIGNAL("clicked()"),
                     self.add_an_account)
        self.connect(self.accountsManaForm.editButton,
                     SIGNAL("clicked()"),
                     self.edit_an_account)
        self.connect(self.accountsManaForm.delButton,
                     SIGNAL("clicked()"),
                     self.del_an_account)

    def show_accounts_mana_form(self):
        self.accounts=self.controller.get_all_accounts()
        if self.accountsManaForm==None:
            self.create_accounts_mana_form(self.accounts)
        else:
            self.accountsManaForm.update_accounts(self.accounts)
        self.accountsManaForm.show()

    def create_new_account_form(self,account):
        self.newAccountForm=NewAccountForm(self.websites,account,self.accountsManaForm)
        self.connect(self.newAccountForm.confirmButton,
                     SIGNAL("clicked()"),
                     self.save_an_account)

    def show_new_account_form(self,account):
        if self.newAccountForm==None:
            self.create_new_account_form(account)
        else:
            self.newAccountForm.update_account(account)
        self.newAccountForm.show()


    def add_an_account(self):
        account=Utils.build_an_empty_account()
        self.show_new_account_form(account)
        self.newAccountForm.setWindowTitle(unicode("添加账户"))

    def edit_an_account(self):
        index=self.accountsManaForm.get_selected()
        if index==-1:
            self.show_notice("请选择需要编辑的账户")
        else:
            account=self.accounts[index]
            self.show_new_account_form(account)
            self.newAccountForm.setWindowTitle(unicode("编辑账户"))

    def save_an_account(self):
        account=self.newAccountForm.output_account(self.show_notice)
        if account!=None:
            self.controller.save_an_account(account)

            self.newAccountForm.hide()
            self.show_accounts_mana_form()
            self.accountsModel=AccountsModel(self.accounts,self.websites)
            self.accountsWin.accountsListView.setModel(self.accountsModel)


    def del_an_account(self):
        index=self.accountsManaForm.get_selected()
        if index==-1:
            self.show_notice("请选择需要删除的账户")
            return
        else:
            account=self.accounts[index]
            
            if self.currentAccount!=None:
                if self.currentAccount["id"]==account["id"] and self.updater.isRunning():
                    self.show_notice("该账户正在进行更新操作，请稍候")
                    return
            website=None
            for web in self.websites:
                if web["id"]==account["website"]:
                    website=web
                    break
            self.delAccountForm=DeleteAccountForm(account,website,self.accountsWin)
            self.connect(self.delAccountForm.confirmButton,
                     SIGNAL("clicked()"),
                     self.del_an_account_confirmed)
            self.delAccountForm.show()

    def del_an_account_confirmed(self):
        account=self.delAccountForm.account
        self.controller.delete_an_account(account)
        self.show_notice("账号已删除")
        self.delAccountForm.hide()
        self.show_accounts_mana_form()
        self.accountsModel=AccountsModel(self.accounts,self.websites)
        self.accountsWin.accountsListView.setModel(self.accountsModel)

        

    def show_about_form(self):
        aboutForm=AboutForm(self.accountsWin)
        aboutForm.show()

#    def show_notice(self,message):
#        print message

    def show_notice(self,message,timeout=QMaemo5InformationBox.DefaultTimeout):
        QMaemo5InformationBox.information(None,"\n"+unicode(message)+"\n",timeout)

    def set_windows_status(self,busy):
        if busy>0:
            self.accountsWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            self.menusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            self.timelineWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            self.statusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            if self.newStatusWin!=None:
                self.newStatusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
        else:
            self.accountsWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            self.menusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            self.timelineWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            self.statusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            if self.newStatusWin!=None:
                self.newStatusWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)


    def create_action(self, text, slot=None, shortcut=None, icon=None,
                  tip=None, checkable=False, signal="triggered()"):
        action = QAction(text, self)
        if icon is not None:
            action.setIcon(QIcon(":/%s.png" % icon))
        if shortcut is not None:
            action.setShortcut(shortcut)
        if tip is not None:
            action.setToolTip(tip)
        if slot is not None:
            self.connect(action, SIGNAL(signal), slot)
        if checkable:
            action.setCheckable(True)
        return action

    def add_actions(self, target, actions):
        for action in actions:
            if action is None:
                target.addSeparator()
            else:
                target.addAction(action)

def main():
    dir=Utils.DATA_FILE_PATH
    if os.access(dir, os.W_OK) == 0:
        os.mkdir(dir)
    dir=Utils.THUMBNAIL_DIR
    if os.access(dir, os.W_OK) == 0:
        os.mkdir(dir)
    dir=Utils.AVATAR_DIR
    if os.access(dir, os.W_OK) == 0:
        os.mkdir(dir)
    # set up logging to file - see previous section for more details
    logging.basicConfig(level=logging.INFO,
                        format='%(asctime)s %(name)-12s %(levelname)-8s %(message)s',
                        datefmt='%y-%m-%d %H:%M',
                        filename=Utils.LOG_FILE,
                        filemode='a')
    # define a Handler which writes INFO messages or higher to the sys.stderr
#    console = logging.StreamHandler()
#    console.setLevel(logging.DEBUG)
#    # set a format which is simpler for console use
#    formatter = logging.Formatter('%(asctime)s %(name)-12s %(levelname)-8s %(message)s')
#    # tell the handler to use this format
#    console.setFormatter(formatter)
#    # add the handler to the root self.logger
#    logging.getLogger('').addHandler(console)
    reload(sys)
    sys.setdefaultencoding('utf8')
    QTextCodec.setCodecForCStrings(QTextCodec.codecForName("UTF-8"))
    app = MaoboApp(sys.argv)
    app.setOrganizationName("SkyBlue Works")
    app.setOrganizationDomain("michaelwong.cn")
    app.setApplicationName("maebo")
#    form = MainWindow()
#    form.show()
    app.exec_()


main()

