#include <QLabel>
#include <QPushButton>
#include <QGridLayout>
#include <QString>
#include <QStringList>

#include "passwd.h"
#include "processrunner.h"
#include "mainwindow.h"

Passwd::Passwd(MainWindow *main)
	: m_main(main)
{
	m_runner = new ProcessRunner;
	m_layout = new QGridLayout;
	setLayout(m_layout);

	m_passwd = new QLabel;
	m_help = new QLabel;
	m_close = new QPushButton(tr("Close"));

	m_layout->addWidget(m_help, 0, 0, 1, 2);
	m_layout->addWidget(m_passwd, 1, 0, Qt::AlignCenter);
	m_layout->addWidget(m_close, 1, 1);

	connect(m_close, SIGNAL(pressed()), this, SLOT(reset()));
	connect(m_runner, SIGNAL(finished(int)),
		this, SLOT(dataAvailable(int)));
}

void
Passwd::generate(void)
{
	const QString generating_str =
		"Generating password!\n"
		"To speed up the generation start some activities,\n"
                "as touching screen or using keyboard!";
	const QString empty_pwd = "------";
	m_runner->start(QString("./password.sh"), QStringList("add"));

	m_help->setText(generating_str);
	m_passwd->setText(empty_pwd);
}

void
Passwd::reset(void)
{
	m_runner->start(QString("./password.sh"),QStringList("remove"));
	m_main->showLauncher();
}

void
Passwd::dataAvailable(int exitCode)
{
	const QString error_str = "Password generation failed!";
	const QString success_str =
		"Password for 'developer' user generated!\n"
		"Password is removed when Close button is clicked";
	QByteArray out;

	if (exitCode != 0) {
		out = m_runner->getStderr();
		m_help->setText(error_str);
	} else {
		out = m_runner->getStdout();
		m_help->setText(success_str);
		if (out.size() != 0)
			m_passwd->setText(out);
	}
}
