#include <QString>
#include <QStringList>
#include <qdebug.h>

#include "processrunner.h"

ProcessRunner::ProcessRunner()
{
	m_proc = new QProcess(this);

	connect(m_proc, SIGNAL(readyReadStandardOutput()), this, SLOT(bufferStdout()));
	connect(m_proc, SIGNAL(readyReadStandardError()), this, SLOT(bufferStderr()));
	connect(m_proc, SIGNAL(finished(int, QProcess::ExitStatus)),
		this, SLOT(complete(int, QProcess::ExitStatus)));
}

ProcessRunner::~ProcessRunner()
{
	delete m_proc;
}

int
ProcessRunner::start(const QString &name, const QStringList &args)
{
	int ec = 0;
	if (m_proc->state() == QProcess::NotRunning) {
		m_stdout.clear();
		m_stderr.clear();
		if (args.at(0) == "")
			m_proc->start(name);
		else
			m_proc->start(name, args);
	} else {
		ec = 1;
	}

	return ec;
}

QByteArray &
ProcessRunner::getStdout(void)
{
	return m_stdout;
}

QByteArray &
ProcessRunner::getStderr(void)
{
	return m_stderr;
}

static void
bufferStd(QByteArray &std, QProcess *proc)
{
	QByteArray line;
	while (!(line=proc->readLine()).isEmpty()) {
		std.append(line);
	}
}

void
ProcessRunner::bufferStdout(void)
{
	m_proc->setReadChannel(QProcess::StandardOutput);
	bufferStd(m_stdout, m_proc);
}

void
ProcessRunner::bufferStderr(void)
{
	m_proc->setReadChannel(QProcess::StandardError);
	bufferStd(m_stderr, m_proc);
}

void
ProcessRunner::complete(int exitCode, QProcess::ExitStatus exitStatus)
{
	bufferStdout();
	bufferStderr();

	qDebug() << this << "done";
	emit finished(exitCode);
}

