#include <QLabel>
#include <QPushButton>
#include <QMouseEvent>
#include <QDebug>

#include "mainwindow.h"
#include "launcher.h"
#include "netinterfaces.h"
#include "processrunner.h"

NetInterfaces::NetInterfaces(MainWindow *main, ProcessRunner *runner)
	: m_main(main), m_runner(runner)
{
	m_layout = new QGridLayout;
	setLayout(m_layout);
	m_edit = 0;
	m_edit_accepted = true;
	QLabel * label = new QLabel("Network configuration. Tap to refresh.\n");
	m_layout->addWidget(label, 0, 0, 1, 5);
	m_layout->setAlignment(label, Qt::AlignTop);
	connect(m_runner, SIGNAL(finished(int)),
		this, SLOT(dataAvailable(int)));

	//updateInterfaces(0); // done from usbmodule at startup, always.
}

class niLabel : public QLabel
{
public:
    niLabel(const QString & text) : QLabel(text) { this->setIndent(20); }
};

class niPushButton : public QPushButton
{
public:
    niPushButton(const QString & text) : QPushButton(text) {}
    QSize sizeHint() const;
};

QSize niPushButton::sizeHint() const {
    static const QSize size = QSize(0, 36); // XXX hardcoded !!!
    return size;
}

void
NetInterfaces::addLine(const QString &name, const QString &ip,
		       const QString &netmask, const QString &flags)
{
	int row = m_layout->rowCount() + 1;

	m_layout->addWidget(new QLabel(name),    row, 0);
	m_layout->addWidget(new niLabel(ip),      row, 1);
	m_layout->addWidget(new niLabel(netmask), row, 2);
	m_layout->addWidget(new niLabel(flags),   row, 3);
	if (name.contains("usb")) {
		m_edit = new niPushButton(QString("Edit"));
		m_edit->setEnabled(m_edit_accepted);
		m_layout->addWidget(m_edit, row, 4);
		connect(m_edit, SIGNAL(pressed()),
			m_main, SLOT(showEdit()));
	}
}

void
NetInterfaces::setEditButtonEnabled(bool enabled)
{
        m_edit_accepted = enabled;
	if (m_edit)
		m_edit->setEnabled(enabled);
}

void
NetInterfaces::clear()
{
	QLayoutItem *item;

	while ((item = m_layout->itemAt(1)) != 0) {
		QWidget *wid = item->widget();
		m_layout->removeItem(item);
		delete wid;
	}
	m_edit = 0;
}

void
NetInterfaces::updateInterfaces(int do_config_ifaces)
{
    if (do_config_ifaces)
	emit config_ifaces();
    else
	m_runner->start(QString("./interfaces.sh"), (QStringList)0);
}

void
NetInterfaces::dataAvailable(int exitCode)
{
	QByteArray out;
	if (exitCode != 0) {
		out = m_runner->getStderr();
		qDebug() << "Err" << out;
		return ;
	} else {
		clear();
		out = m_runner->getStdout();
		qDebug() << out;

		// Output is line based.
		QList<QByteArray> lines = out.split('\n');
		int n = lines.size();

		// Remove trailing empty line.
		// This happens if output ends to newline.
		if (lines.at(n - 1) == "")
			n--;

		// Line format: iface ip mask flags
		for (int i=0; i < n; i++) {
			QList<QByteArray> args = lines.at(i).split(' ');
			addLine(args.at(0), args.at(1),
				args.at(2), args.at(3));
		}
	}
}

void
NetInterfaces::mousePressEvent(QMouseEvent * event)
{
	(void)event;
	setMinimumHeight(height());
	clear();
	updateInterfaces(0);
}
