#ifndef _EDIT_INTERFACE_H_
#define _EDIT_INTERFACE_H_

#include <QWidget>

class QGridLayout;
class QStackedWidget;
class QCheckBox;
class QComboBox;
class QPushButton;
class QLabel;
class QLineEdit;

class MainWindow;
class ProcessRunner;

class EditInterface : public QWidget
{
	Q_OBJECT
public:
	EditInterface(MainWindow *main, ProcessRunner *runner);

public slots:
	void configure0();
	void configure();

private slots:
	void toggleDhcp(int state);
	void toggleRoute(int state);

private:
	MainWindow *m_main;
	ProcessRunner *m_runner;

	QGridLayout *m_layout;
	enum { DHCP_SERVER = 0, DHCP_CLIENT, DHCP_STATIC };
	QComboBox *m_dhcp;
	QStackedWidget *m_stack;
	QCheckBox *m_route;
	QLabel *m_peerip;
	QLabel *m_defroute;
        QPushButton *m_configure;
	QPushButton *m_cancel;
	QLabel *m_ipaddress;
	QLabel *m_netmask;
	QLineEdit *m_iptxt;
	QLineEdit *m_masktxt;
	QLineEdit *m_gwtxt;
};
#endif
