#!/bin/sh

# Copyright (c) 2009 Nokia Corporation. All rights reserved.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation
# files (the "Software"), to deal in the Software without
# restriction, including without limitation the rights to use,
# copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following
# conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
# HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

# Input parameters:
#    action - add    genrate password and set to developer user
#             remove remove the password from developer user
# Return codes:
#    0        success
#    1        error

set -eu
#exec 2>> /tmp/maddev-pwd.log; date >&2; set -x; : "$@"

LC_ALL=C LANG=C
export LC_ALL LANG
PATH=$HOME/bin:/bin:/sbin:/usr/bin:/usr/sbin
export PATH

die () { echo "$@" >&2; exit 1; }

if [ $# -lt 1 ] ; then
	die "Input parameter missing"
fi

case $1 in

	add)
		# Generate password
		passwd=`perl -e 'open I, "/dev/random"; read I, $c, 6; close I;
			print qw( a c e f h j k m n s u v w x y z )[$_ & 15]
				foreach (unpack("c6", $c)); print "\n";'`
		# Set password to developer user
		echo developer:$passwd | devrootsh chpasswd
                if [ $? != 0 ] ; then
			die "Setting password failed"
                fi
		echo $passwd
		;;
	remove)
		# Remove password from developer user
		devrootsh usermod -p '*' developer
		;;
esac
