#include <QHBoxLayout>
#include <QPushButton>
#include <QProcess>
#include <QDebug>

#include "launcher.h"
#include "mainwindow.h"

Launcher::Launcher(MainWindow *main)
{
	m_layout = new QHBoxLayout;
	setLayout(m_layout);

	m_buttons[PASSWD_BUTTON] = new QPushButton(tr("Developer\nPassword"));
	m_buttons[METHER_BUTTON] = new QPushButton(tr("Manage\nUsb"));
	m_buttons[XTERM_BUTTON] = new QPushButton(tr("Developer\nXTerm"));

	//m_buttons[XTERM_BUTTON]->setEnabled(false);
	m_layout->addWidget(m_buttons[PASSWD_BUTTON]);
	m_layout->addWidget(m_buttons[METHER_BUTTON]);
	m_layout->addWidget(m_buttons[XTERM_BUTTON]);

	connect(m_buttons[PASSWD_BUTTON], SIGNAL(pressed()),
		main, SLOT(showPasswd()));
	connect(m_buttons[METHER_BUTTON], SIGNAL(pressed()),
		main, SLOT(showUsbManage()));
	connect(m_buttons[XTERM_BUTTON], SIGNAL(pressed()),
		this, SLOT(startXTerm()));
}

void
Launcher::startXTerm(void)
{
	QProcess *xterm = new QProcess;

	xterm->startDetached(QString("./xterm.sh"));
	//xterm->start(QString("./xterm.sh", (QStringList)0);

	delete xterm;
}

