#include <clutter/clutter.h>
#include "tangle/tangle-widget.h"
#include "tangle/tangle-linear-gradient.h"
#include "tangle/tangle-box-layout.h"
#include "tangle/tangle-template.h"
#include "tangle/tangle-stylesheet.h"
#include <math.h>


int main(int argc, char** argv) {
	ClutterActor* stage;
	TangleStyle* style;
	TangleTemplate* template;
	GValue value = { 0 };
	TangleStylesheet* stylesheet;
	ClutterActor* container;
	int i;
	ClutterActor* widget;
	ClutterColor* start_color;
	ClutterColor* end_color;
	ClutterColor* bg_color;
	ClutterActor* gradient;
	ClutterActor* text;
	gchar* s;
	TangleSpacing spacing;
	
	clutter_init(&argc, &argv);
	
	stage = clutter_stage_get_default();
	g_object_set(G_OBJECT(stage), "width", 800.0, "height", 480.0, NULL);

	style = tangle_style_new(TANGLE_TYPE_WIDGET);
	tangle_style_set_for_name(style, "styled");

	template = tangle_template_new(TANGLE_TYPE_LINEAR_GRADIENT);
		start_color = clutter_color_new(128, 128, 255, 255);
		end_color = clutter_color_new(255, 255, 128, 255);
	tangle_properties_set(TANGLE_PROPERTIES(template),
	                      "start-color", CLUTTER_TYPE_COLOR, start_color,
	                      "end-color", CLUTTER_TYPE_COLOR, end_color,
			      NULL);

	g_value_init(&value, TANGLE_TYPE_TEMPLATE);
	g_value_set_object(&value, template);
	tangle_style_set_style_property(style, "background-actor", &value);
	g_value_unset(&value);
	
	stylesheet = tangle_stylesheet_new();
	tangle_stylesheet_add_style(stylesheet, style);

	container = tangle_widget_new();
	tangle_stylesheet_apply(stylesheet, G_OBJECT(container));
	tangle_widget_set_layout(TANGLE_WIDGET(container), tangle_box_layout_new());
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), container);

	spacing.left = spacing.right = spacing.top = spacing.bottom = 20.0;
	for (i = 0; i < 1; i++) {
		widget = tangle_widget_new();
		clutter_actor_set_name(widget, "styled");
		clutter_actor_set_reactive(widget, TRUE);
		tangle_actor_set_margin(TANGLE_ACTOR(widget), &spacing);
		tangle_widget_set_padding(TANGLE_WIDGET(widget), &spacing);
		tangle_widget_set_layout(TANGLE_WIDGET(widget), tangle_box_layout_new());
		tangle_widget_set_background_color(TANGLE_WIDGET(widget), bg_color);
		text = clutter_text_new();
		s = g_strdup_printf("Number %d", i + 1);
		clutter_text_set_text(CLUTTER_TEXT(text), s);
		g_free(s);
		tangle_widget_add_after(TANGLE_WIDGET(widget), text, NULL, NULL, NULL);
		clutter_container_add_actor(CLUTTER_CONTAINER(container), widget);
	}

	clutter_actor_show(stage);
	
	clutter_main();
	
	return 0;
}
