/*
 * tangle-button.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2009-2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_BUTTON_H__
#define __TANGLE_BUTTON_H__

#include <clutter/clutter.h>
#include "tangle-widget.h"

#define TANGLE_TYPE_BUTTON (tangle_button_get_type ())
#define TANGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TANGLE_TYPE_BUTTON, TangleButton))
#define TANGLE_IS_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TANGLE_TYPE_BUTTON))
#define TANGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TANGLE_TYPE_BUTTON, TangleButtonClass))
#define TANGLE_IS_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TANGLE_TYPE_BUTTON))
#define TANGLE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TANGLE_TYPE_BUTTON, TangleButtonClass))

#define TANGLE_TYPE_BUTTON_MODE (tangle_button_mode_get_type())

typedef struct _TangleButtonPrivate TangleButtonPrivate;

typedef struct _TangleButton {
	TangleWidget parent_instance;

	TangleButtonPrivate* priv;
} TangleButton;

typedef struct _TangleButtonClass {
	TangleWidgetClass parent_class;
	
	gboolean (*clicked)(TangleButton* button);
	gboolean (*held)(TangleButton* button);
} TangleButtonClass;

GType tangle_button_get_type(void) G_GNUC_CONST;

typedef enum {
	TANGLE_BUTTON_CLICKABLE = 0,
	TANGLE_BUTTON_SELECTABLE,
	TANGLE_BUTTON_RADIO
} TangleButtonMode;

GType tangle_button_mode_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_button_new(void);
ClutterActor* tangle_button_new_with_background_actor(ClutterActor* normal_background_actor);
ClutterActor* tangle_button_new_with_background_actors(ClutterActor* normal_background_actor, ClutterActor* interactive_background_actor);
ClutterActor* tangle_button_new_selectable(void);
ClutterActor* tangle_button_new_selectable_with_background_actor(ClutterActor* normal_background_actor);
ClutterActor* tangle_button_new_selectable_with_background_actors(ClutterActor* normal_background_actor, ClutterActor* interactive_background_actor, ClutterActor* selected_background_actor);
ClutterActor* tangle_button_new_radio(void);
ClutterActor* tangle_button_new_radio_with_background_actor(ClutterActor* normal_background_actor);
ClutterActor* tangle_button_new_radio_with_background_actors(ClutterActor* normal_background_actor, ClutterActor* interactive_background_actor, ClutterActor* selected_background_actor);

TangleButtonMode tangle_button_get_mode(TangleButton* button);
void tangle_button_set_mode(TangleButton* button, TangleButtonMode mode);

ClutterActor* tangle_button_get_normal_background_actor(TangleButton* button);
void tangle_button_set_normal_background_actor(TangleButton* button, ClutterActor* actor);
ClutterActor* tangle_button_get_interactive_background_actor(TangleButton* button);
void tangle_button_set_interactive_background_actor(TangleButton* button, ClutterActor* actor);
ClutterActor* tangle_button_get_selected_background_actor(TangleButton* button);
void tangle_button_set_selected_background_actor(TangleButton* button, ClutterActor* actor);

gboolean tangle_button_get_selected(TangleButton* button);
void tangle_button_set_selected(TangleButton* button, gboolean selected);

void tangle_button_stop_highlighting(TangleButton* button);

#endif
