/*
 * tangle-bufferer.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2011 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_BUFFERER_H__
#define __TANGLE_BUFFERER_H__

#include "tangle-widget.h"

#define TANGLE_TYPE_BUFFERER (tangle_bufferer_get_type())
#define TANGLE_BUFFERER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_BUFFERER, TangleBufferer))
#define TANGLE_IS_BUFFERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_BUFFERER))
#define TANGLE_BUFFERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_BUFFERER, TangleBuffererClass))
#define TANGLE_IS_BUFFERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_BUFFERER))
#define TANGLE_BUFFERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_BUFFERER, TangleBuffererClass))

typedef struct _TangleBuffererPrivate TangleBuffererPrivate;

typedef struct _TangleBufferer {
	TangleWidget parent_instance;
	TangleBuffererPrivate* priv;
} TangleBufferer;

typedef struct _TangleBuffererClass {
	TangleWidgetClass parent_class;
} TangleBuffererClass;

GType tangle_bufferer_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_bufferer_new(void);
ClutterActor* tangle_bufferer_new_with_layout(TangleLayout* layout);

void tangle_bufferer_mark_allocation_changed(ClutterActor* actor);

#endif
