
/*
 * tangle-misc.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2009-2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_MISC_H__
#define __TANGLE_MISC_H__

#include <glib-object.h>
#include <clutter/clutter.h>

typedef struct _TangleValueCalculationFunctions {
	void (*add)(GValue* value, GValue* addend);
	void (*substract)(GValue* value, GValue* subtrahend);
	void (*multiply)(GValue* value, GValue* multiplier);
	void (*divide)(GValue* value, GValue* divider);
} TangleValueCalculationFunctions;

gboolean tangle_init(int* argc, char*** argv);

#define TANGLE_UNREF_AND_NULLIFY_OBJECT(x) ((x) = tangle_unref_object(x))

gpointer tangle_unref_object(gpointer object);

typedef gpointer TanglePointers;

TanglePointers* tangle_pointers_new(gint n, ...);
void tangle_pointers_get(TanglePointers* pointers, gint n, ...);
void tangle_pointers_free(TanglePointers* pointers, gint n);

#define TANGLE_POINTERS(p) ((TanglePointers*)(p))

gboolean tangle_lookup_construct_properties(GType type, guint n_construct_properties, GObjectConstructParam* construct_properties, const gchar* first_property_name, ...);
GObject* tangle_construct_with_extra_properties(GObject* (*constructor)(GType, guint, GObjectConstructParam*), GType type, guint n_construct_properties, GObjectConstructParam* construct_properties, const gchar* first_extra_property_name, ...);

gboolean tangle_signal_accumulator_non_null_handled(GSignalInvocationHint* ihint, GValue* return_accu, const GValue* handler_return, gpointer user_data);

gboolean tangle_signal_connect_dynamically(GObject* object, const gchar* signal_name, const gchar* function_name, gpointer user_data);
gboolean tangle_signal_connect_swapped_dynamically(GObject* object, const gchar* signal_name, const gchar* function_name, gpointer user_data);
gboolean tangle_signal_connect_object_swapped_dynamically(GObject* object, const gchar* signal_name, const gchar* function_name, GObject* other_object);

gboolean tangle_signal_connect_dynamically_from_script(GObject* object, const gchar* signal_name, const gchar* function_name, ClutterScript* script);

void tangle_value_add(GValue* value, GValue* addend);
void tangle_value_substract(GValue* value, GValue* subtrahend);
void tangle_value_multiply(GValue* value, GValue* multiplier);
void tangle_value_divide(GValue* value, GValue* divider);

void tangle_value_register_calculation_functions(GType value_type, TangleValueCalculationFunctions* calculation_functions);


#endif
