/*
 * tangle-event.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_EVENT_H__
#define __TANGLE_EVENT_H__

#define TANGLE_TYPE_EVENT (tangle_event_get_type())
#define TANGLE_EVENT(e) ((TangleEvent*)(e))

typedef enum _TangleEventType TangleEventType;
typedef struct _TangleAnyEvent TangleAnyEvent;
typedef struct _TangleInteractionEvent TangleInteractionEvent;
typedef union _TangleEvent TangleEvent;

#include "tangle-actor.h"

enum _TangleEventType {
	TANGLE_EVENT_NONE = 0,
	TANGLE_EVENT_INTERACTION_BEGAN,
	TANGLE_EVENT_INTERACTION_ENDED
};

struct _TangleAnyEvent {
	TangleEventType type;
	TangleActor* sender;
};

struct _TangleInteractionEvent {
	TangleEventType type;
	TangleActor* sender;
	guint x_axis : 1;
	guint y_axis : 1;
	guint dragging : 1;
};

union _TangleEvent {
	TangleEventType type;
	TangleAnyEvent any;
	TangleInteractionEvent interaction;
};

TangleEvent* tangle_event_new(TangleEventType type, TangleActor* sender);
TangleEvent* tangle_event_copy(const TangleEvent* event);
void tangle_event_free(TangleEvent* event);

void tangle_actor_send_interaction_began_event(TangleActor* actor, gboolean x_axis, gboolean y_axis, gboolean dragging);
void tangle_actor_send_interaction_ended_event(TangleActor* actor, gboolean x_axis, gboolean y_axis, gboolean dragging);

#endif
