/*
 * tangle-floating-actor.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_FLOATING_ACTOR_H__
#define __TANGLE_FLOATING_ACTOR_H__

#include "tangle-wrapper-actor.h"

#define TANGLE_TYPE_FLOATING_ACTOR (tangle_floating_actor_get_type())
#define TANGLE_FLOATING_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_FLOATING_ACTOR, TangleFloatingActor))
#define TANGLE_IS_FLOATING_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_FLOATING_ACTOR))
#define TANGLE_FLOATING_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_FLOATING_ACTOR, TangleFloatingActorClass))
#define TANGLE_IS_FLOATING_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_FLOATING_ACTOR))
#define TANGLE_FLOATING_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_FLOATING_ACTOR, TangleFloatingActorClass))

typedef struct _TangleFloatingActorPrivate TangleFloatingActorPrivate;

typedef struct _TangleFloatingActor {
	TangleWrapperActor parent_instance;
	TangleFloatingActorPrivate* priv;
} TangleFloatingActor;

typedef struct _TangleFloatingActorClass {
	TangleWrapperActorClass parent_class;
} TangleFloatingActorClass;

typedef enum _TangleFloatingMode {
	TANGLE_FLOATING_MODE_NONE = 0,
	TANGLE_FLOATING_MODE_COLLAPSE,
	TANGLE_FLOATING_MODE_PLACEHOLDER
} TangleFloatingMode;

GType tangle_floating_actor_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_floating_actor_new(ClutterActor* wrapped);

TangleFloatingMode tangle_floating_actor_get_floating_mode(TangleFloatingActor* floating_actor);
void tangle_floating_actor_set_floating_mode(TangleFloatingActor* floating_actor, TangleFloatingMode floating_mode);

gfloat tangle_floating_actor_get_floating_x(TangleFloatingActor* floating_actor);
void tangle_floating_actor_set_floating_x(TangleFloatingActor* floating_actor, gfloat floating_x);
gfloat tangle_floating_actor_get_floating_y(TangleFloatingActor* floating_actor);
void tangle_floating_actor_set_floating_y(TangleFloatingActor* floating_actor, gfloat floating_y);
void tangle_floating_actor_set_floating_position(TangleFloatingActor* floating_actor, gfloat floating_x, gfloat floating_y);

gfloat tangle_floating_actor_get_floating_scale_x(TangleFloatingActor* floating_actor);
void tangle_floating_actor_set_floating_scale_x(TangleFloatingActor* floating_actor, gfloat floating_scale_x);
gfloat tangle_floating_actor_get_floating_scale_y(TangleFloatingActor* floating_actor);
void tangle_floating_actor_set_floating_scale_y(TangleFloatingActor* floating_actor, gfloat floating_scale_y);
void tangle_floating_actor_set_floating_scale(TangleFloatingActor* floating_actor, gfloat floating_scale_x, gfloat floating_scale_y);

gfloat tangle_floating_actor_get_floating_scale_center_x(TangleFloatingActor* floating_actor);
void tangle_floating_actor_set_floating_scale_center_x(TangleFloatingActor* floating_actor, gfloat floating_scale_center_x);
gfloat tangle_floating_actor_get_floating_scale_center_y(TangleFloatingActor* floating_actor);
void tangle_floating_actor_set_floating_scale_center_y(TangleFloatingActor* floating_actor, gfloat floating_scale_center_y);
void tangle_floating_actor_set_floating_scale_center(TangleFloatingActor* floating_actor, gfloat floating_scale_center_x, gfloat floating_scale_center_y);

guchar tangle_floating_actor_get_placeholder_opacity(TangleFloatingActor* floating_actor);
void tangle_floating_actor_set_placeholder_opacity(TangleFloatingActor* floating_actor, guchar placeholder_opacity);

#endif
