/*
 * tangle-scroller.h
 *
 * This file is part of Tangle Toolkit - A graphical actor library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_SCROLLER_H__
#define __TANGLE_SCROLLER_H__

#include "tangle-widget.h"
#include "tangle-clamp.h"

#define TANGLE_TYPE_SCROLLER (tangle_scroller_get_type())
#define TANGLE_SCROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_SCROLLER, TangleScroller))
#define TANGLE_IS_SCROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_SCROLLER))
#define TANGLE_SCROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_SCROLLER, TangleScrollerClass))
#define TANGLE_IS_SCROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_SCROLLER))
#define TANGLE_SCROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_SCROLLER, TangleScrollerClass))

typedef struct _TangleScrollerPrivate TangleScrollerPrivate;

typedef struct _TangleScroller {
	TangleWidget parent_instance;
	TangleScrollerPrivate* priv;
} TangleScroller;

typedef struct _TangleScrollerClass {
	TangleWidgetClass parent_class;
	
	void (*clamp_scrolling_offset_x)(TangleScroller* scroller, TangleClamp* clamp);
	void (*clamp_scrolling_offset_y)(TangleScroller* scroller, TangleClamp* clamp);
} TangleScrollerClass;

GType tangle_scroller_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_scroller_new(void);

gfloat tangle_scroller_get_scrolling_offset_x(TangleScroller* scroller);
void tangle_scroller_set_scrolling_offset_x(TangleScroller* scroller, gfloat scrolling_offset_x);
gfloat tangle_scroller_get_scrolling_offset_y(TangleScroller* scroller);
void tangle_scroller_set_scrolling_offset_y(TangleScroller* scroller, gfloat scrolling_offset_y);

gfloat tangle_scroller_get_scrolling_width(TangleScroller* scroller);
gfloat tangle_scroller_get_scrolling_height(TangleScroller* scroller);

gfloat tangle_scroller_get_scrolling_threshold_x(TangleScroller* scroller);
void tangle_scroller_set_scrolling_threshold_x(TangleScroller* scroller, gfloat scrolling_threshold_x);
gfloat tangle_scroller_get_scrolling_threshold_y(TangleScroller* scroller);
void tangle_scroller_set_scrolling_threshold_y(TangleScroller* scroller, gfloat scrolling_threshold_y);
void tangle_scroller_set_scrolling_threshold(TangleScroller* scroller, gfloat scrolling_threshold);

gboolean tangle_scroller_get_repeat_x(TangleScroller* scroller);
void tangle_scroller_set_repeat_x(TangleScroller* scroller, gboolean repeat_x);
gboolean tangle_scroller_get_repeat_y(TangleScroller* scroller);
void tangle_scroller_set_repeat_y(TangleScroller* scroller, gboolean repeat_y);

gboolean tangle_scroller_get_continuous_x(TangleScroller* scroller);
void tangle_scroller_set_continuous_x(TangleScroller* scroller, gboolean continuous_x);
gboolean tangle_scroller_get_continuous_y(TangleScroller* scroller);
void tangle_scroller_set_continuous_y(TangleScroller* scroller, gboolean continuous_y);

gboolean tangle_scroller_get_kinetic_scrolling(TangleScroller* scroller);
void tangle_scroller_set_kinetic_scrolling(TangleScroller* scroller, gboolean kinetic_scrolling);
gdouble tangle_scroller_get_scrolling_deceleration(TangleScroller* scroller);
void tangle_scroller_set_scrolling_deceleration(TangleScroller* scroller, gdouble scrolling_deceleration);

void tangle_scroller_clamp_scrolling_offset_x(TangleScroller* scroller);
void tangle_scroller_clamp_scrolling_offset_y(TangleScroller* scroller);
void tangle_scroller_clamp_offsets(TangleScroller* scroller);

void tangle_scroller_clamp_page_boundaries(TangleScroller* scroller, TangleClamp* clamp);

#endif
