#include <tangle/tangle.h>

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* texture;
	ClutterActor* scrolling_actor;
	
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);

	texture = clutter_texture_new_from_file("test_image_135x100.jpg", NULL);
	clutter_actor_set_reactive(texture, TRUE);
	scrolling_actor = tangle_scrolling_actor_new(texture);
	clutter_actor_set_size(scrolling_actor, 50.0, 50.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), scrolling_actor);
	
	clutter_actor_show_all(stage);	
	clutter_main();

	return 0;
}
