/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

class ImageList {
    int[] pixbufs;
    int width = -1;
    int height = -1;
    Image[] images = new Image[4];

    public ImageList() {
        this.pixbufs = new int[4];
    }

    public int add(Image image) {
        int n;
        for (n = 0; n < this.images.length; ++n) {
            if (this.images[n] != null && this.images[n].isDisposed()) {
                OS.g_object_unref(this.pixbufs[n]);
                this.images[n] = null;
                this.pixbufs[n] = 0;
            }
            if (this.images[n] == null) break;
        }
        if (n == this.images.length) {
            Image[] imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
            int[] nArray = new int[this.pixbufs.length + 4];
            System.arraycopy(this.pixbufs, 0, nArray, 0, this.pixbufs.length);
            this.pixbufs = nArray;
        }
        this.set(n, image);
        return n;
    }

    public void dispose() {
        if (this.pixbufs == null) {
            return;
        }
        for (int i = 0; i < this.pixbufs.length; ++i) {
            if (this.pixbufs[i] == 0) continue;
            OS.g_object_unref(this.pixbufs[i]);
        }
        this.images = null;
        this.pixbufs = null;
    }

    public Image get(int n) {
        return this.images[n];
    }

    int getPixbuf(int n) {
        return this.pixbufs[n];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (image != this.images[i]) continue;
            return i;
        }
        return -1;
    }

    int indexOf(int n) {
        if (n == 0) {
            return -1;
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (n != this.pixbufs[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void put(int n, Image image) {
        int n2 = this.images.length;
        if (0 > n || n >= n2) {
            return;
        }
        if (image != null) {
            this.set(n, image);
        } else {
            this.images[n] = null;
            if (this.pixbufs[n] != 0) {
                OS.g_object_unref(this.pixbufs[n]);
            }
            this.pixbufs[n] = 0;
        }
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        for (int i = 0; i < this.images.length; ++i) {
            if (image != this.images[i]) continue;
            OS.g_object_unref(this.pixbufs[i]);
            this.images[i] = null;
            this.pixbufs[i] = 0;
        }
    }

    void set(int n, Image image) {
        int n2;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
        int n3 = Display.createPixbuf(image);
        if (this.width == -1 || this.height == -1) {
            this.width = nArray[0];
            this.height = nArray2[0];
        }
        if (nArray[0] != this.width || nArray2[0] != this.height) {
            n2 = OS.gdk_pixbuf_scale_simple(n3, this.width, this.height, 2);
            OS.g_object_unref(n3);
            n3 = n2;
        }
        if ((n2 = this.pixbufs[n]) != 0) {
            if (this.images[n] == image) {
                OS.gdk_pixbuf_copy_area(n3, 0, 0, this.width, this.height, n2, 0, 0);
                OS.g_object_unref(n3);
                n3 = n2;
            } else {
                OS.g_object_unref(n2);
            }
        }
        this.pixbufs[n] = n3;
        this.images[n] = image;
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.images.length; ++i) {
            if (this.images[i] == null) continue;
            if (this.images[i].isDisposed()) {
                OS.g_object_unref(this.pixbufs[i]);
                this.images[i] = null;
                this.pixbufs[i] = 0;
            }
            if (this.images[i] == null) continue;
            ++n;
        }
        return n;
    }
}

