/*
 * This file is part of signoncrypto-qt
 *
 * Copyright (C) 2009-2010 Nokia Corporation.
 *
 * Contact: Alberto Mardegan <alberto.mardegan@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef ENCRYPTOR_GLIB_H
#define ENCRYPTOR_GLIB_H

#include <glib-object.h>

/**
 * Encrypts contents of a hash table
 * @param map The GHashTable whose contents to encrypt
 * @param encrypted_map Pointer to a GHashTable that receives
 *        the encrypted data
 * @param pid Identifier of the process whose resource token
 *        to use for encryption. Pass 0 to use current process
 * @return 0 on success, non-zero on failure
 */
#ifdef __cplusplus
extern "C"
#endif
int signon_encrypt_hash_table(const GHashTable *map, GHashTable *encrypted_map, pid_t pid);
/**
 * Decrypts contents of a hash table
 * @param map The GHashTable whose contents to decrypt
 * @param decrypted_map Pointer to a GHashTable that receives
 *        the decrypted data
 * @param pid Identifier of the process whose resource token
 *        to use for decryption. Pass 0 to use current process
 * @return 0 on success, non-zero on failure
 */
#ifdef __cplusplus
extern "C"
#endif
int signon_decrypt_hash_table(const GHashTable *map, GHashTable *decrypted_map, pid_t pid);

/**
 * Encrypts a string
 * @param string The string to encrypt. The character
*         encoding of the string must be UTF-8
 * @param encrypted_string Pointer to a pointer to receive
 *        the encrypted string. The caller must release this
 *        buffer using g_free
 * @param pid Identifier of the process whose resource token
 *        to use for encryption. Pass 0 to use current process
 * @return 0 on success, non-zero on failure
 */
#ifdef __cplusplus
extern "C"
#endif
int signon_encrypt_string(const gchar *string, gchar **encrypted_string, pid_t pid);
/**
 * Decrypts a string
 * @param string The string to decrypt
 * @param decrypted_string Pointer to a pointer to receive
 *        the decrypted string. The string will be UTF-8
*         encoded. The caller must release this buffer using
*         g_free
 * @param pid Identifier of the process whose resource token
 *        to use for decryption. Pass 0 to use current process
 * @return 0 on success, non-zero on failure
 */
#ifdef __cplusplus
extern "C"
#endif
int signon_decrypt_string(const gchar *string, gchar **decrypted_string, pid_t pid);

#endif // ENCRYPTOR_GLIB_H
