//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qmaemo5editbar_c.h"

#if defined MAEMO5
QMaemo5EditBarH QMaemo5EditBar_create(QWidgetH parent)
{
	return (QMaemo5EditBarH) new QMaemo5EditBar((QWidget*)parent);
}

void QMaemo5EditBar_destroy(QMaemo5EditBarH handle)
{
	delete (QMaemo5EditBar *)handle;
}

QMaemo5EditBarH QMaemo5EditBar_create2(PWideString text, QWidgetH parent)
{
	QString t_text;
	copyPWideStringToQString(text, t_text);
	return (QMaemo5EditBarH) new QMaemo5EditBar(t_text, (QWidget*)parent);
}

void QMaemo5EditBar_text(QMaemo5EditBarH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QMaemo5EditBar *)handle)->text();
	copyQStringToPWideString(t_retval, retval);
}

void QMaemo5EditBar_addButton(QMaemo5EditBarH handle, QAbstractButtonH b)
{
	((QMaemo5EditBar *)handle)->addButton((QAbstractButton*)b);
}

void QMaemo5EditBar_removeButton(QMaemo5EditBarH handle, QAbstractButtonH b)
{
	((QMaemo5EditBar *)handle)->removeButton((QAbstractButton*)b);
}

void QMaemo5EditBar_buttons(QMaemo5EditBarH handle, PPtrIntArray retval)
{
	QList<QAbstractButton*> t_retval;
	t_retval = ((QMaemo5EditBar *)handle)->buttons();
	copyQListTemplateToPtrIntArray(t_retval, retval);
}

void QMaemo5EditBar_setText(QMaemo5EditBarH handle, PWideString text)
{
	QString t_text;
	copyPWideStringToQString(text, t_text);
	((QMaemo5EditBar *)handle)->setText(t_text);
}

#endif
