//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qlayout_c.h"

int QLayout_margin(QLayoutH handle)
{
	return (int) ((QLayout *)handle)->margin();
}

int QLayout_spacing(QLayoutH handle)
{
	return (int) ((QLayout *)handle)->spacing();
}

void QLayout_setMargin(QLayoutH handle, int p1)
{
	((QLayout *)handle)->setMargin(p1);
}

void QLayout_setSpacing(QLayoutH handle, int p1)
{
	((QLayout *)handle)->setSpacing(p1);
}

void QLayout_setContentsMargins(QLayoutH handle, int left, int top, int right, int bottom)
{
	((QLayout *)handle)->setContentsMargins(left, top, right, bottom);
}

void QLayout_setContentsMargins2(QLayoutH handle, const QMarginsH margins)
{
	((QLayout *)handle)->setContentsMargins(*(const QMargins*)margins);
}

void QLayout_getContentsMargins(QLayoutH handle, int* left, int* top, int* right, int* bottom)
{
	((QLayout *)handle)->getContentsMargins(left, top, right, bottom);
}

void QLayout_contentsMargins(QLayoutH handle, QMarginsH retval)
{
	*(QMargins *)retval = ((QLayout *)handle)->contentsMargins();
}

void QLayout_contentsRect(QLayoutH handle, PRect retval)
{
	QRect t_retval;
	t_retval = ((QLayout *)handle)->contentsRect();
	copyQRectToPRect(t_retval, retval);
}

bool QLayout_setAlignment(QLayoutH handle, QWidgetH w, unsigned int alignment)
{
	return (bool) ((QLayout *)handle)->setAlignment((QWidget*)w, (Qt::Alignment)alignment);
}

bool QLayout_setAlignment2(QLayoutH handle, QLayoutH l, unsigned int alignment)
{
	return (bool) ((QLayout *)handle)->setAlignment((QLayout*)l, (Qt::Alignment)alignment);
}

void QLayout_setSizeConstraint(QLayoutH handle, QLayout::SizeConstraint p1)
{
	((QLayout *)handle)->setSizeConstraint(p1);
}

QLayout::SizeConstraint QLayout_sizeConstraint(QLayoutH handle)
{
	return (QLayout::SizeConstraint) ((QLayout *)handle)->sizeConstraint();
}

void QLayout_setMenuBar(QLayoutH handle, QWidgetH w)
{
	((QLayout *)handle)->setMenuBar((QWidget*)w);
}

QWidgetH QLayout_menuBar(QLayoutH handle)
{
	return (QWidgetH) ((QLayout *)handle)->menuBar();
}

QWidgetH QLayout_parentWidget(QLayoutH handle)
{
	return (QWidgetH) ((QLayout *)handle)->parentWidget();
}

void QLayout_invalidate(QLayoutH handle)
{
	((QLayout *)handle)->invalidate();
}

void QLayout_geometry(QLayoutH handle, PRect retval)
{
	QRect t_retval;
	t_retval = ((QLayout *)handle)->geometry();
	copyQRectToPRect(t_retval, retval);
}

bool QLayout_activate(QLayoutH handle)
{
	return (bool) ((QLayout *)handle)->activate();
}

void QLayout_update(QLayoutH handle)
{
	((QLayout *)handle)->update();
}

void QLayout_addWidget(QLayoutH handle, QWidgetH w)
{
	((QLayout *)handle)->addWidget((QWidget*)w);
}

void QLayout_addItem(QLayoutH handle, QLayoutItemH p1)
{
	((QLayout *)handle)->addItem((QLayoutItem*)p1);
}

void QLayout_removeWidget(QLayoutH handle, QWidgetH w)
{
	((QLayout *)handle)->removeWidget((QWidget*)w);
}

void QLayout_removeItem(QLayoutH handle, QLayoutItemH p1)
{
	((QLayout *)handle)->removeItem((QLayoutItem*)p1);
}

unsigned int QLayout_expandingDirections(QLayoutH handle)
{
	return (unsigned int) ((QLayout *)handle)->expandingDirections();
}

void QLayout_minimumSize(QLayoutH handle, PSize retval)
{
	*(QSize *)retval = ((QLayout *)handle)->minimumSize();
}

void QLayout_maximumSize(QLayoutH handle, PSize retval)
{
	*(QSize *)retval = ((QLayout *)handle)->maximumSize();
}

void QLayout_setGeometry(QLayoutH handle, PRect p1)
{
	QRect t_p1;
	copyPRectToQRect(p1, t_p1);
	((QLayout *)handle)->setGeometry(t_p1);
}

QLayoutItemH QLayout_itemAt(QLayoutH handle, int index)
{
	return (QLayoutItemH) ((QLayout *)handle)->itemAt(index);
}

QLayoutItemH QLayout_takeAt(QLayoutH handle, int index)
{
	return (QLayoutItemH) ((QLayout *)handle)->takeAt(index);
}

int QLayout_indexOf(QLayoutH handle, QWidgetH p1)
{
	return (int) ((QLayout *)handle)->indexOf((QWidget*)p1);
}

int QLayout_count(QLayoutH handle)
{
	return (int) ((QLayout *)handle)->count();
}

bool QLayout_isEmpty(QLayoutH handle)
{
	return (bool) ((QLayout *)handle)->isEmpty();
}

int QLayout_totalHeightForWidth(QLayoutH handle, int w)
{
	return (int) ((QLayout *)handle)->totalHeightForWidth(w);
}

void QLayout_totalMinimumSize(QLayoutH handle, PSize retval)
{
	*(QSize *)retval = ((QLayout *)handle)->totalMinimumSize();
}

void QLayout_totalMaximumSize(QLayoutH handle, PSize retval)
{
	*(QSize *)retval = ((QLayout *)handle)->totalMaximumSize();
}

void QLayout_totalSizeHint(QLayoutH handle, PSize retval)
{
	*(QSize *)retval = ((QLayout *)handle)->totalSizeHint();
}

QLayoutH QLayout_layout(QLayoutH handle)
{
	return (QLayoutH) ((QLayout *)handle)->layout();
}

void QLayout_setEnabled(QLayoutH handle, bool p1)
{
	((QLayout *)handle)->setEnabled(p1);
}

bool QLayout_isEnabled(QLayoutH handle)
{
	return (bool) ((QLayout *)handle)->isEnabled();
}

void QLayout_closestAcceptableSize(PSize retval, const QWidgetH w, const QSizeH s)
{
	*(QSize *)retval = QLayout::closestAcceptableSize((const QWidget*)w, *(const QSize*)s);
}

QLayoutItemH QLayout_to_QLayoutItem(QLayoutH handle)
{
	return (QLayoutItemH)(QLayoutItem *)(QLayout *)handle;
}

