#ifndef MAEMOAPPLICATIONHANDLER_H
#define MAEMOAPPLICATIONHANDLER_H
#include <QObject>
#include <QXmlStreamReader>
#include <QList>
#include <QPixmap>

#include "HttpConnector.h"
#include "MaemoApplication.h"
#include "MaemoApplicationDetails.h"
#include "queueelement.h"
#include "maemocategory.h"
#include "restrequest.h"

class MaemoApplicationHandler : public QObject {
    Q_OBJECT

    public:
            //const
            static const int LoggedIn;
            static const int LoggedInConnectionError;
            static const int LoggedInCredentialsError;

            enum comments {NotAuthorized,CommentConnectionError,CommentSuccess};

            //constructors
            MaemoApplicationHandler (QString proxy="",int port=0,int timeout=0);
            //public functions

            //requests a list of all available applications
            void requestApplications (QString OS,
                                      QString cat,
                                      int page,
                                      int pageSize,
                                      QString keyword,
                                      QString sortmode="");
            void requestApplications(RestRequest *req);
            //requests details of an application
            void requestApplicationData (QString uid);
            //request an image by a url
            void requestImage (QString url, QString id="", QString info="", bool addToQueue=true);
            //request an install file
            void requestInstallFile (QString url);
            void requestCategories (QString OS = "Maemo5");
            void requestLogin (QString uname,QString pw);
            void parseCommentsOnly (QByteArray, int preloadComments = -1);
            void emptyQueue();
            bool isUserLoggedIn ();
            void logOut();
            void commentApplication (int rating, QString comment, QString applicationname);
            QString userName ();
            void setHandlerMode(const QString& handlerMode = "");

    private:
            QString queryBuilder ( QString OS,QString cat,int page,int pageSize,QString keyword,QString sortmode);
            QString formalizeQString (QString);
    private slots:
            // private slots to proceed the requests
            void parseAppListResponse (QByteArray,int);
            void parseSingleAppResponse (QByteArray,int);
            void parseCategoryResponse (QByteArray,int);
            void proceedImageResponse (QByteArray,int);
            void loginResponse (QByteArray,int);
            void commentResponse (QByteArray,int);
            void proceedQueue ();


    public slots:
            void proceedInstallFileResponse (QByteArray, int);
    signals:
            //signals returning the responses of the requests
            // application list
            void applicationListReady (QList<MaemoApplication *>*);
            //application details
            void applicationDetailsReady(MaemoApplicationDetails*);
            //categories
            void categoriesReady (QList <MaemoCategory*>*);
            //image
            void imageReady(QPixmap*,QString, QString);
            //commments
            void commentsParsed (QList <MaemoComment*> *);
            //logged in
            void loggedIn (int);
            void commented (int);
            void raiseError (QString);

    private:
            QString OCS_URL;
            QString PRODUCT_URL;
            //QString COMMENT_URL;
            QXmlStreamReader xmlReader;
            HttpConnector *connector;
            QList <QueueElement*> *requestQueue;
            QString mode;
            QueueElement *imageInUse;
            bool queueConnected;
            QString username;
};
#endif
