#include <QtNetwork>
#include <QString>
#include <QChar>
#include <QObject>
#include <QTextStream>
#include <QNetworkAccessManager>
#include <QNetworkRequest>

#include "HttpConnector.h"

/* public functions */ 
HttpConnector::HttpConnector() {
    busy = false;
    http = new QNetworkAccessManager ();
    cache = new QNetworkDiskCache ();
    #ifdef Q_WS_HILDON
        cache->setCacheDirectory ("/opt/appdownloader/meta/cache/");
    #else
        cache->setCacheDirectory ("/tmp/.maemoclient/");
    #endif
    cache->setMaximumCacheSize (100000);
    http->setCache(cache);
    timeout=10000;
}

HttpConnector::HttpConnector(int _timeout,int _cacheSize) {
    http = new QNetworkAccessManager ();
    cache = new QNetworkDiskCache ();
    #ifdef Q_WS_HILDON
        cache->setCacheDirectory ("/opt/appdownloader/meta/cache/");
    #else
        cache->setCacheDirectory ("/tmp/.maemoclient/");
    #endif
    cache->setMaximumCacheSize (100000);
    http->setCache (cache);
    timeout=_timeout;
}

void HttpConnector::setProxy (QString host,int port) {
    QTextStream out (stdout);
    QNetworkProxy proxy;
    proxy.setType (QNetworkProxy::HttpProxy);
    proxy.setHostName (host);
    proxy.setPort (port);
    http->setProxy (proxy);
}

void HttpConnector::connectToHost (QString url) {
    QTextStream out (stdout);
    out << url << endl;
    if (!busy) {
        busy = true;
        timer = new QTimer();
        QNetworkRequest req;
        req.setUrl (QUrl (url));
        req.setAttribute(QNetworkRequest::CacheLoadControlAttribute,QVariant ((int)QNetworkRequest::PreferCache));
        out << req.url().toString() << endl;
        /* now connect */
        reply = http->get (req);
        req.~QNetworkRequest();
        out << "connected" << endl;
        // read the data, which is received
        connect (reply, SIGNAL(readChannelFinished()), this, SLOT(readResponse ()));
        // timer for connection timeout
        connect (timer, SIGNAL(timeout()),this, SLOT (setRequestTimeout()));
        /* set network timeout */
        timer->start (10000);
     } else {
         out << "busy" << endl;
     }
}


bool HttpConnector::isBusy() {
    return busy;
}

void HttpConnector::readResponse () {
        QTextStream out (stdout);
        int bytes = reply->bytesAvailable();
        if (bytes > 0) {
            response = reply->readAll();
            out << QString (bytes) << endl;
            emit getResponseContent (false,new QString (response));
            emit getRawData (false,response);
        } else {
            //todo
        }

        reply->close();
        timer->stop();
        disconnect (reply, SIGNAL(readChannelFinished()), this, SLOT(readResponse ()));
        disconnect (timer, SIGNAL(timeout()),this, SLOT (setRequestTimeout()));
        busy = false;
        emit isFree();
        reply->reset();
    }

void HttpConnector::requestStarted (int id) {
        QTextStream out (stdout);
        out << "started" + QString::number(id) << endl;
}


void HttpConnector::requestsDone () {
    timer->stop();
    busy=false;
    emit isFree();
}


/* private functions */

void HttpConnector::setRequestTimeout() {
    disconnect (reply, SIGNAL(readChannelFinished()), this, SLOT(readResponse ()));
    disconnect (timer, SIGNAL(timeout()),this, SLOT (setRequestTimeout()));
    /* stop all requests when timeout occurs (see QTimer->timeout signal */
    reply->abort();
    busy=false;
    emit isFree();
    emit getResponseContent (true,new QString("Connection timeout!"));
}
