/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008-2011 LUT. .
 *
 * @name WLANListener.cc
 * @memo Implementation of WLANListener.h for linux, uses ioctl.
 *
 * @version 0.1
 * date     14.4.2011
 * change   14.4.2011
 */

#ifndef __WLANLISTENER_H__
#define __WLANLISTENER_H__

#include <syslog.h>
#include <stdio.h>
#include <time.h>
#include "AbstractListener.h"
#include "AbstractStateConverter.h"
#include "IFSearch.h"

// Poll every second
#define _WL_POLL_INTERVAL 2.00

#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG( A... )
#endif

/**
 * @memo Interface for CWLANListener.cc, implements MAbstractListener
 * @doc Implementation of this declared interface should be used by WLAN plugin
 * only. 
 * 
 * @see MAbstractListener
 * @see MAbstractStateConverter
 * @see CMaemoWLANCreator
 */
class CWLANListener : public MAbstractListener
{

public:
	CWLANListener(MAbstractStateConverter* aConverter);
	virtual ~CWLANListener();
	
	// Listener interface
	bool Connect();
	void Disconnect();
	void CheckInitialState();
	void CheckState();
	const std::string& GetName();
	
private:
	CWLANListener();
	
	CIFSearch iIfSearch;

	// Name of the listener
	std::string iName;
	
	time_t iPrevPoll;

	//
	MAbstractStateConverter* iConverter;
};

#endif /*__WLANLISTENER_H__*/
