/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name TCPConnection.h
 * @memo TCP-specific implementation of the MAbstractConnection
 * interface.
 *
 * @version 0.2
 * date     30.06.2003
 * change   28.04.2010
 */

#ifndef __TCPCONNECTION_H__
#define __TCPCONNECTION_H__

#include "AbstractConnection.h"
#include "IFSearch.h"

/**
 * @memo TCP-specific implementation of the MAbstractConnection
 * interface.
 * @doc TCP-specific implementation of the MAbstractConnection interface.
 * This class offers a unified interface through what TCP can be used
 * like any other transport medium in the PeerHood environment. Note that no
 * instances of this class should be created directly. Instead, use the
 * provided PeerHood factory class.
 *
 * @see MAbstractConnection
 */


class CTCPConnection : public MAbstractConnection
{
 public:
  CTCPConnection(const std::string& aIface, const std::string& aPluginBase);
  ~CTCPConnection();
  MAbstractConnection* AcceptL();
  
  void Close();

  bool Connect(const std::string& aAddress, int aPort);
  bool Disconnect();
  bool Listen();
  bool Listen(int aPort);
  bool IsConnected();
  bool IsListening();
  bool HasData();
  
  int Write(const void* aOutBuf, int aLength);
  int Read(void* aInBuf, int aLength);
  const std::string& GetRemoteAddress();
  unsigned int GetDeviceChecksum();
  void SetDeviceChecksum(unsigned int aChecksum);
  int GetFd();

 private:
  bool GetInterfaces();
	int iSocket;
  bool iConnected;
  bool iIsListening;
  std::string iRemoteAddress;
  struct IFInfo *ifaces;
  std::string iFace;
  std::string iPluginBase;
  unsigned int iChecksum;
};

#endif //__TCPCONNECTION_H__
