/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003-2011 LUT. .
 *
 * @name PHRTI.h
 * @memo PeerHood's Run time information class
 *
 * @version 0.1
 * date     19.04.2011
 * change   19.04.2011
 */

#ifndef __PHRTI_H__
#define __PHRTI_H__

#include <string>

enum RTInfoType {
	_RT_INFO_WLAN_IF = 0,
	_RT_INFO_BT_IF,
	_RT_INFO_GPRS_IF
};

#define _RT_INFO_PATH "/var/run/peerhood"
#define _RT_INFO_PATH_WLAN _RT_INFO_PATH "/wlan.rti"
#define _RT_INFO_PATH_BT _RT_INFO_PATH "/bluetooth.rti"
#define _RT_INFO_PATH_GPRS _RT_INFO_PATH "/gprs.rti"
#define _RT_INFO_FILEMODE S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH
#define _RT_INFO_DIRMODE S_IRWXU|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH

/**
 * @memo 
 * @doc 
 */

class PHRTI
{
public:
	static PHRTI* GetInstance();
	bool AddRunTimeInfo(RTInfoType aType, const std::string& aInfo);
	const std::string* GetRunTimeInfo(RTInfoType aType);
	~PHRTI();
private:
	PHRTI();
	bool CreatePath();
	bool CreateFile(RTInfoType aType);
	bool CheckFilePermissions(struct stat* aStat);
	bool CheckDirPermissions(struct stat* aStat);
	bool CorrectFilePermissions(const std::string& aPath);
	
	static PHRTI* iInstance;
	bool iRTInfoAccess;
};
#endif //__PHRTI_H__
