##   This file is part of PeerHood.
##
##   PeerHood is free software: you can redistribute it and/or modify
##   it under the terms of the GNU Lesser General Public License 
##   version 2 as published by the Free Software Foundation.
##
##   PeerHood is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU Lesser General Public License for more details.
##
##   You should have received a copy of the GNU Lesser General Public
##   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
##

## Common definitions and functionalities to all sub-Makefiles
## see http://www.gnu.org/software/make/manual/make.html
##
## ! RELATIVE TO SUB LEVEL MODULE MAKEFILE ! ASSUME ../ FOR ROOT !
##
## White space matters ! about in every aspect of GNU Make, assume nothing !
##
## Don't put any rules here, put them into MakeCommonRules.mk or into module
## Makefile.
## 
	
##############################################################################
## Default configuration
## Based on GNU Make Manual: 14 Makefile Conventions

## General project information
project = peerhood
libproject = lib$(project)
majorver = 0
version = 0.1.3
configfile = .phconfig

## location: result directory structure
## this location applies only into sub level makefiles
## result = prefix in building
resultdir = ../result
resultbindir = $(resultdir)/bin
resultlibdir = $(resultdir)/lib
resultdatadir = $(resultdir)/share/$(project)
resultsysconfdir = $(resultdir)/etc
resultincludebasedir = $(resultdir)/include
resultincludedir = $(resultincludebasedir)/$(project)
resultdocdir = $(resultdir)/share/doc
resulthtmldir = $(resultdocdir)/$(project)


## location: install directories, 
prefix = /usr
bindir = $(prefix)/sbin
libdir = $(prefix)/lib
libphdir = $(libdir)/$(project)
datadir = $(prefix)/share/$(project)
sysconfdir = $(prefix)/etc
includedir= $(prefix)/include/$(project)
htmldir = $(prefix)/share/doc/$(project)

## location: temporary build directory
## TODO: change buildir variable name
BUILDDIR = ../tmpbuild

## Force basic shell 
SHELL = /bin/sh

## clean suffixes and set project used
.SUFFIXES:
.SUFFIXES: .cc .o .h .d .cc.d

## Target platform !! UNUSED!
TARGET=i386

## Building environment
BUILD_ENV=x86

## Build debian packet, off by default
BUILD_DEB_PACKET=n

## C++ compiler and linker
CXX=g++

## C++ warining compile flags
CXX.warn = -Wall -Wshadow 
#CXX.warn = -W -Wall -ansi -pedantic

## C++ development compile flags: debug or release
#CXX.devel = -g
#CXX.devel = -O2
CXX.devel = -g -O

## C pre-processor flags
CPPFLAGS = -I$(resultincludebasedir)
CPPFLAGS += -I. -I$(resultincludedir) # fixes for incorrect include usage 

## combine C++ compiling flags
CXXFLAGS = $(CXX.warn) $(CXX.devel) $(CPPFLAGS) 

## Linking flags
LDFLAGS = -L$(resultlibdir)

## Thread library 
PTHREAD.lib = -lpthread

## Bluetooh library
BLUETOOTH.lib = `pkg-config --libs bluez`

## Dynamic linking library
DL.lib = -ldl

## Peerhood library
PEERHOOD.lib = -lpeerhood

## DBUS library
DBUS.lib = `pkg-config --cflags dbus-glib-1 --libs dbus-glib-1`

## Create diretory, creating parents as well
MKDIR = mkdir -p

## Remove directory, don't remove if not empty (this is not rm -rf !)
## This is function, use by:
## $(call RMDIR,dir-to-remove)
define RMDIR
@if test -d $(1); then rmdir --parents $(1) 2>/dev/null;echo "rmdir $(1)"; fi 
endef

## Strip extra binary stuff 
STRIP = strip --strip-unneeded

## installation variables
#INSTALL = 
#INSTALL_PROGRAM = $(INSTALL) 
#INSTALL_DATA

##############################################################################
## Find and include configuration

#-include MakeVars
#-include ../MakeVars

# Product type selection
DEBUG=y
PH_DEBUG=y
LIB_DEBUG=y
# create directory and its parents

##############################################################################
## Apply configuration

ifeq ($(LIB_DEBUG), y)
CPPFLAGS += -DPH_LIB_DEBUG
endif

ifeq ($(PH_DEBUG), y)
CPPFLAGS += -DPH_DEBUG
endif

ifeq ($(PH_OLD_PLUGINMAP),y)
CPPFLAGS += -D__PH_OLD_PLUGIN_STYLE__
endif

## DEBIAN PACKET CREATION

## Debian control file
debcontrol_source = $(libproject)
debcontrol_section = net
debcontrol_priority = optional
debcontrol_maintainer = Jussi Laakkonen <jussi.laakkonen@lut.fi>
debcontrol_package = $(libproject)
debcontrol_description = PeerHood subsystem, daemon and networking plugins (WLAN & BT)
debcontrol_description_add = control_description

## arch dependant stuff
ifeq ($(BUILD_ENV), n900)
DEB_POSTFIX = maemo5
debfile = $(libproject)_$(version)~1$(DEB_POSTFIX)_armel.deb
debcontrol_architecture = armel
debcontrol_version = $(version)~1$(DEB_POSTFIX)
debcontrol_depends = bluez (>= 3.26), libbluetooth3 (>= 4.00-0), libdbus-glib-1-2 (>=0.74-2), dbus (>= 1.1.20), libc6 (>= 2.5)
debcontrol_postinst = postinst_maemo
endif

ifeq ($(BUILD_ENV), n810)
DEB_POSTFIX = maemo4
debfile = $(libproject)_$(version)~1$(DEB_POSTFIX)_armel.deb
debcontrol_architecture = armel
debcontrol_version = $(version)~1$(DEB_POSTFIX)
debcontrol_depends = bluetooth (>= 3.26), libbluetooth2 (>= 3.00-0), libdbus-glib-1-2 (>=0.74-2), dbus (>= 1.1.20), libc6 (>= 2.5)
debcontrol_postinst = postinst_maemo
endif

ifeq ($(BUILD_ENV), x86)
DEB_POSTFIX = i386
debfile = $(libproject)_$(version)~1linux_$(DEB_POSTFIX).deb
debcontrol_architecture = $(DEB_POSTFIX)
debcontrol_version = $(version)~1$(DEB_POSTFIX)
debcontrol_depends = bluez (>= 3.26), libbluetooth3 (>= 4.00-0), libdbus-glib-1-2 (>=0.74-2), dbus (>= 1.1.20), libc6 (>= 2.5)
debcontrol_postinst = postinst_reqular
endif

## Debian additional stuff directory
debmat = debmaterial

## Debian directory
debdir = debian

## Debian control
debctrl = $(debdir)/DEBIAN

## Debian bin
debbin = $(debdir)/usr/bin

## Debian lib root
deblib = $(debdir)/usr/lib

## Debian lib for plugins
debphlib = $(debdir)/usr/lib/$(project)

## Debian include for project
debinclude = $(debdir)/usr/include/$(project)

## Debian documentation (README, copyright, changelog)
debdoc = $(debdir)/usr/share/doc/$(libproject)

## Debian share (.phconfig)
debshare = $(debdir)/usr/share/$(libproject)

## Debian man
debman = $(debdir)/usr/share/man/man1
