/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name MaemoSystemCreator.h
 * @memo Class for creating Maemo System listener that implements
 * MAbstractListenerCreator interface.
 *
 * @version 0.12
 * date     25.08.2008
 * change   17.12.2008
 */


#ifndef __MAEMOSYSTEMCREATOR_H__
#define __MAEMOSYSTEMCREATOR_H__

#include "AbstractListenerCreator.h"

/**
 * @memo Implementation of MAbstractListenerCreator interface
 * @doc Used by ListenerFactory to create Maemo System listener 
 * object. Instance of this class is statically created. The system listener
 * is created with type "daemon", meant to be used by PeerHood daemon
 * only.
 * 
 * @see CMaemoSystemListener
 * @see MAbstractListener
 * @see MAbstractListenerCreator
 * @see MAbstractStateConverter
 */
class CMaemoSystemCreator : public MAbstractListenerCreator
{
public:
	CMaemoSystemCreator();
	MAbstractListener* CreateListener(const std::string& aName, MAbstractStateConverter* aConverter);
	
private:
	// Prototype name
	std::string iProto;
};

#endif /*__MAEMOSYSTEMCREATOR_H__*/
