/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2003 LUT. .
 *
 * @name PeerHood.cc
 * @memo Implementation of the PeerHood getter function.
 *
 * @version 0.1
 * date     20.05.2003
 * change   20.05.2003
 */

#include "PeerHoodImpl.h"


/**
 * @memo Getter of the PeerHood singleton.
 * @doc Getter of the PeerHood singleton. An application can receive a pointer
 * to the active PeerHood instance via this method. If an instance doesn't 
 * exist then it's created. This getter method ensures that only one instance
 * of the PeerHood implementation is created at any given moment of time.
 *
 * @param aCallback Pointer to the callback interface that should be notified
 * if an event takes place.
 *
 * @return pointer to the currently active PeerHood implementation
 */
MPeerHood* MPeerHood::GetInstance(CBasicCallback* aCallback)
{
  return CPeerHoodImpl::GetInstance(aCallback);
}

