/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name MaemoWLANListener.h
 * @memo Interface for MaemoWLANListener, implements MAbstractListener
 * interface. A listener for WLAN plugin in Maemo environment, changes the
 * state of the WLAN plugin based on adapter state.
 *
 * @version 0.13
 * date     12.10.2008
 * change   7.1.2009
 */

#ifndef __MAEMOWLANLISTENER_H__
#define __MAEMOWLANLISTENER_H__

#include <dbus/dbus.h>
#include <syslog.h>
#include <stdio.h>
#include "AbstractListener.h"
#include "AbstractStateConverter.h"

#define ERR(format, msg...) printf(format "\n",## msg)

#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG( A... )
#endif

/**
 * @memo Interface for CMaemoWLANListener.cc, implements MAbstractListener
 * @doc Implementation of this declared interface should be used by WLAN plugin
 * only in Maemo environment. Implementation listens signals from ICD and changes
 * the state of the owner component accordingly. Initial state of the owner plugin (WLAN)
 * should be checked at the start up stage of the owner plugin (CheckInitialState()). Initial
 * check is conducted with blocking method call via D-BUS. Currently a private connection
 * to D-Bus is used. When the implementation of this class is created it automatically
 * registers to the given owner component.
 * 
 * @see MAbstractListener
 * @see MAbstractStateConverter
 * @see CMaemoWLANCreator
 */
class CMaemoWLANListener : public MAbstractListener
{

public:
	CMaemoWLANListener(MAbstractStateConverter* aConverter);
	virtual ~CMaemoWLANListener();
	
	// Listener interface
	bool Connect();
	void Disconnect();
	void CheckInitialState();
	void CheckState();
	const std::string& GetName();
	
private:
	CMaemoWLANListener();
	bool SetupConnection();
	bool RegisterSignals();
	void HandleMessage(DBusMessage* message);
	
	// Connection object
	DBusConnection* iConnection;

	// Name of the listener
	std::string iName;

	//
	MAbstractStateConverter* iConverter;
};

#endif /*__MAEMOWLANLISTENER_H__*/
