/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name pdu.h
 * @memo Defines PDUs used in the PeerHood system.
 *
 * @version 0.1
 * date     08.04.2003
 * change   08.04.2003
 */

#ifndef __PDU_H__
#define __PDU_H__

/// The number of different commands between the daemon and the library.
const int MAX_COMMAND_TYPE = 3;

/// Command opcodes.
enum ECommands {
  PH_INIT = 0x00,             /// Connection initialization.
  PH_GET_DEVICELIST,          /// Fetch remote devices.
  PH_INSERT_SERVICE,          /// Add a new service to the PeerHood daemon.
  PH_REMOVE_SERVICE,          /// Remove a service from the daemon.
  PH_DIRECT_DATA,             /// Direct data connection open.
  PH_GET_LOCAL_SERVICELIST,   /// Get a list of locally registered services.
  PH_OK,                      /// Generic OK message.
  PH_ALREADY_REGISTERED,      /// Tried to register a service with a name already in use.
  PH_NO_CALLBACK,              /// Connection request arrived but there's no callback registered.
  PH_REESTABLISH,
  PH_GET_FREE_PORT,
  PH_GET_PEER_INFO,						/// When new connection is established request information of connecting device
  PH_GET_CHECKSUM							/// Got PH_GET_PEER_INFO from peer -> this is used to get own checksum from daemon
};


/// Generic PeerHood command pdu. Every command starts with this sequence.
struct TCommand 
{
  u_int8_t iCommand;          /// Command type.
  u_int32_t iPid;             /// Caller's process id.
} __attribute__ ((packed));


/// Marshalled service's header.
struct TServiceData
{
  u_int16_t  iAttributePosition;
  u_int16_t  iNamePosition;
  u_int16_t  iPort;
  u_int32_t  iPid;

} __attribute__ ((packed));

#endif // __PDU_H__
