/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2003 LUT. .
 *
 * @name BasicCallback.cc
 * @memo Basic implementation of the CBasicCallback interface.
 *
 * @version 0.1
 * date     19.05.2003
 * change   19.05.2003
 */

#include <BasicCallback.h>

CBasicCallback::~CBasicCallback()
{
}

/**
 * @memo Receives PeerHood notifications.
 * @doc Receives notifications from the PeerHood library. Users of the PeerHood
 * are strongly encouraged to implement threir own versions of this method 
 * because the default implementation takes no action in regard to the reveiced
 * events.
 *
 * @param aEvent The type of the occurred event.
 * @param aAddress The address of the device that the event concerns.
 *
 * @return none
 */
void CBasicCallback::Notify(TEventType aEvent, const std::string& aAddress)
{
}



/**
 * @memo Default handler for a new connection notification.
 * @doc Default handler for a new connection notification. The default handler 
 * silently closes the offered connection and deletes the connection object so
 * in order to do something usefull a new version more suitable for the 
 * application in question should be introduced.
 *
 * @return none
 */

void CBasicCallback::NewConnection(const unsigned short aPort, MAbstractConnection* aConnection, int aConnectionId)
{
  aConnection->Disconnect();

  delete aConnection;
}

