
#include <iostream>
#include <stdlib.h>
#include <cstdio>
#include <sstream>
#include <time.h>
#include <fstream>
#include <string>

#include "hot_cube.h"
using namespace std;


#include <math.h>

#define COEF_TRANS_IN 0.0005 //Trans
#define COEF_TEMP 0.01 //Cp
#define COEF_TRANS_OUT 0.0001 //Tran

float flux(const float t1,const float t2, const double dist, const float coef){
  return (t2-t1)*coef/dist;
}

void print_tab(const std::vector< std::vector< float > > mytab){

for(unsigned int i(0);i<mytab.size();++i){
    for(unsigned int j(0);j<mytab[i].size();++j)
      {
        cout << mytab[i][j] << " , ";
      }
    cout << endl;
  }
cout << endl;
}


void print_tab2(const std::vector< std::vector< float > > mytab,std::string nom){
    std::stringstream cmd;
    cmd << "./script_plot.sh " << nom.c_str()<< ".bin "<<  nom.c_str()<< ".png "<< mytab.size() << " "<<  mytab[0].size()<< " " << "100" ;
    nom=nom+".bin";
    ofstream fichier(nom.c_str(), ios::out | ios::trunc);  //déclaration du flux et ouverture du fichier
        
        if(fichier)  // si l'ouverture a réussi
        {   
for(unsigned int i(0);i<mytab.size();++i){
    for(unsigned int j(0);j<mytab[i].size();++j)
      {
        fichier << mytab[i][j] << " ";
      }
    fichier << endl;
  }
fichier << endl;

fichier.close();
system(cmd.str().c_str());
        }
}

std::vector< std::vector< float > > algo(int nb_iter, int w, int h,float outside_tmp,std::vector< std::vector< float > > temperature, int s){
  int nbh,nbw;
  nbh= temperature.size();
  nbw = temperature[0].size();
  std::vector< std::vector< float > > result(nbh,std::vector<float>(nbw,0)); 
  std::vector< std::vector< float > > tmp;
  int i,j;
  int k,kk;
  float change;
  if(s>200)s=200;
  int it =0;
  
  while(it<nb_iter){
  for(i=0;i<nbh;i++){
    for(j=0;j<nbw;j++){
      change=0;
      k=-1;
      while(k<2){
        kk=-1;
        while(kk<2){  
          if(((i+k) > (nbh-1)) || ((i+k) < 0) || ((j+kk) < 0 )||((j+kk) > (nbw-1))){
            change+=flux(temperature[i][j],outside_tmp,sqrt(k*k+kk*kk),COEF_TRANS_OUT);
          }else{
            if((kk==0) && (k==0)){
              // on ne fait rien = We do nothing
            }else{             
              change+=flux(temperature[i][j],temperature[i+k][j+kk],sqrt(k*k+kk*kk),COEF_TRANS_IN);
            }           
          }
          kk++;
        }
        k++;
      }      
      result[i][j]=  temperature[i][j] + (float)(change*(float)COEF_TEMP*s*s);
    }
  }

  tmp=result;
  result=temperature;
  temperature=tmp;
	it++;
  }
  print_tab2(temperature,"end");  
  return temperature;  
}



/*int main( int argc, const char* argv[] ){

int w = 1;
int h = 1;
int s = 150;

  std::vector< std::vector< float > > tempe(w*s,std::vector<float>(h*s,100)); 

  tempe = algo(atoi(argv[1]),w, h,20,tempe,s);


return 1;

}*/
