/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name WLANMonitor.h
 * @memo WLAN specific realization of the MAbstractMonitor interface.
 *
 * @version 0.1
 * date     31.07.2003
 * change   31.07.2003
 */

#ifndef __WLANMONITOR_H__
#define __WLANMONITOR_H__

#include <AbstractMonitor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/**
 * @memo WLAN specific realization of the MAbstractMonitor interface.
 * @doc WLAN specific realization of the MAbstartactMonitor interface.
 *
 * @see MAbstractPinger
 */
class CWLANMonitor : public MAbstractMonitor
{
 public:
  CWLANMonitor(const std::string& aAddress);
  ~CWLANMonitor();
  const std::string& GetAddress();
  bool InRange();
  int Monitor();

 private:

  bool iInRange;
  std::string iAddress;
  FILE *iWlanInfo;
};

#endif // __WLANMONITOR_H__
