/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

// Emacs, hail the mighty -*-C++-*-

/**
 * Copyright 2003 LUT. .
 *
 * @name BasicCallback.h
 * @memo Defines the default callback interface that every application wishing
 * to receive PeerHood events must inherit.
 *
 * @version 0.1
 * date     19.05.2003
 * change   19.05.2003
 */

#ifndef __BASICCALLBACK_H__
#define __BASICCALLBACK_H__

#include "AbstractConnection.h"
#include "AbstractDevice.h"

/**
 * "added new enum"   PH_WEAK_LINK
 */
enum TEventType
{
  PH_DEVICE_LOST = 0x00,
  PH_DEVICE_FOUND, // TODO: bad style, explicit numbering for hex enums
  PH_WEAK_LINK
};

#ifdef __cplusplus

/**
 * @memo Defines a callback interface that every application wishing
 * to receive PeerHood events must implement. 
 * @doc Defines the default callback interface that every application wishing
 * to receive PeerHood events must inherit. Events are generated from actions
 * like abnormal disconnections, newly established connections, changes in the
 * state of a service/device under monitoring etc.
 *
 * @see CPeerHood
 */
class CBasicCallback
{
 public:
 	virtual ~CBasicCallback();
  virtual void Notify(TEventType aEvent, const std::string& aAddress);
  virtual void NewConnection(const unsigned short aPort, MAbstractConnection* aConnection, int aConnectionId);
};

#else
	typedef
		struct CBasicCallback
			CBasicCallback;
#endif // __cplusplus

#endif // __BASICCALLBACK_H__
