##   This file is part of PeerHood.
##
##   PeerHood is free software: you can redistribute it and/or modify
##   it under the terms of the GNU Lesser General Public License 
##   version 2 as published by the Free Software Foundation.
##
##   PeerHood is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU Lesser General Public License for more details.
##
##   You should have received a copy of the GNU Lesser General Public
##   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
##

## Common rules to all module Makefiles
## see http://www.gnu.org/software/make/manual/make.html
##
## ! RELATIVE TO SUB LEVEL MODULE MAKEFILE ! ASSUME ../ FOR ROOT !
##
## White space matters ! about in every aspect of GNU Make, assume nothing !
##
## Inputs from module's own variables:
## SRCS
## MODULEDIR
## 

##############################################################################
## Make targets
## These targets are dispatched in top level Makefile to sub Makefiles.
## Making has three parts:
##  -pre part  = preparation
##  -do part   = actual actions
##  -post part = finishing actions
## use these target parts in rules
## 

# Default target, give help
help: help-pre help-do help-post

build: build-pre build-do build-post

clean: clean-pre clean-do clean-post

check: check-pre check-do check-post 

install: install-pre install-do install-post 

# these are not files
.PHONY: \
	help help-pre help-do help-post \
	build build-pre build-do build-post \
	clean clean-pre clean-do clean-post \
	check check-pre check-do check-post \
	install install-pre install-do install-post  

##############################################################################
## Result directory management

$(resultdir):
	$(MKDIR) $@

$(resultbindir):
	$(MKDIR) $@

$(resultlibdir):
	$(MKDIR) $@

$(resultdatadir):
	$(MKDIR) $@

$(resultsysconfdir):
	$(MKDIR) $@

$(resultincludebasedir):
	$(MKDIR) $@

$(resultincludedir):
	$(MKDIR) $@

$(resulthtmldir):
	$(MKDIR) $@

$(resultdocdir):
	$(MKDIR) $@

build-pre:: $(resultdir) $(resultbindir) $(resultlibdir) $(resultdatadir) \
  $(resultsysconfdir) $(resultincludedir) $(resultdocdir) $(resulthtmldir)     

## Brute force result directory cleaning
clean-post::
	$(call RMDIR,$(resulthtmldir))
	$(call RMDIR,$(resultdocdir))	
	$(call RMDIR,$(resultincludedir))
	$(call RMDIR,$(resultincludebasedir))
	$(call RMDIR,$(resultsysconfdir))
	$(call RMDIR,$(resultdatadir))
	$(call RMDIR,$(resultlibdir))
	$(call RMDIR,$(resultbindir))
	$(call RMDIR,$(resultdir))

##############################################################################
## Temporary module build dir management.

build-pre:: $(MODULEDIR)

$(MODULEDIR):
	$(MKDIR) $@

clean-post::
	$(call RMDIR,$(MODULEDIR))

##############################################################################
## C++ compiling 

$(MODULEDIR)/%.o:%.cc
	$(CXX) $(CXXFLAGS) -fPIC -c $< -o $@

##############################################################################
## Include file publishing 

$(resultincludedir)/%.h: %.h
	cp $< $@

##############################################################################
## Source to include file dependency creation.
## TODO: Dependecy creation is made on clean* targets, change it to not.

DEPS = $(addprefix $(MODULEDIR)/,$(SRCS:%.cc=%.cc.d))

$(DEPS): $(MODULEDIR)

# TODO: fix not to include system headers
# HIDDEN now 
$(MODULEDIR)/%.cc.d: %.cc
	@$(CXX) $(CPPFLAGS) -M -MT $(@:%.cc.d=%.o) $< > $@

clean-do::
	rm -f $(DEPS)

# Include dependence files, this also creates internal make dependencies.
# Do not include dependency files on non build targets. It will produce 
# unnessesary errors.
# TODO: remove "-" on include; include errors on first time make run
ifneq ($(MAKECMDGOALS),clean)
ifneq ($(MAKECMDGOALS),help)
-include $(DEPS)
endif
endif



