/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name MaemoWLANCreator.h
 * @memo Maemo specific implementation of MabstractListenerCreator, initializes 
 * MaemoWLANListener -objects.
 *
 * @version 0.03
 * date     12.10.2008
 * change   7.1.2009
 */

#ifndef __MAEMOWLANCREATOR_H__
#define __MAEMOWLANCREATOR_H__

#include <syslog.h>
#include "AbstractListenerCreator.h"

#define ERR(format, msg...) syslog(LOG_ERR, "ERROR: " format "\n" , ## msg)

#ifdef PH_DEBUG
#define DBG(format, msg...) syslog(LOG_DEBUG, format "\n" , ## msg)
#else
#define DBG(A...)
#endif

/**
 * @memo Maemo WLAN specific implementation of MAbstractListenerCreator
 * @doc Creates CMaemoWLANListener-objects (with "wlan" as aName param.) Instance
 * of this is initialized when plugin-listener-maemo-wlan is loaded and automatically registers
 * itself to ListenerFactory, so initialization should be dynamic.
 * 
 * @see MAbstractListenerCreator
 * @see MabstractListener
 * @see MAbstractStateConverter
 * @see ListenerFactory
 */
class CMaemoWLANCreator : public MAbstractListenerCreator
{
public:
	CMaemoWLANCreator();
	MAbstractListener* CreateListener(const std::string& aName, MAbstractStateConverter* aConverter);
	
private:
	// Prototype name
	std::string iProto;
};

#endif /*MAEMOWLANCREATOR_H_*/
