<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="USERNAME"/>  
<xsl:param name="TOKEN"/>  
<xsl:param name="SECRET"/>  
<xsl:param name="TIME"/>  
<xsl:param name="NONCE"/>
<xsl:param name="SUBDOMAIN"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>
<xsl:variable name="PAGE" select="/data/Request/Params/number[@name='page']"/>
<xsl:variable name="PAGE_SIZE" select="/data/Request/Params/number[@name='pageSize']"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">friends</xsl:attribute>
        <xsl:attribute name="function">getListFriends</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:if test="/data/Request/Params/@id">
                    <xsl:value-of select="/data/Request/Params/@id"/>
                </xsl:if>
                <xsl:if test="not(/data/Request/Params/@id)">
                    <xsl:value-of select="$USERNAME"/>
                </xsl:if>
            </xsl:attribute>

            <xsl:element name="{$ARRAY}">

                <xsl:attribute name="name">ContactList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:choose>
                    <xsl:when test="string-length($PAGE) != 0 and string-length($PAGE_SIZE) != 0">
                    <xsl:variable name="from" select="(number($PAGE) - 1)*number($PAGE_SIZE)"/>
                    <xsl:variable name="to" select="number($from) + number($PAGE_SIZE)+1"/>
                    <xsl:attribute name="quantity">
                            <xsl:value-of select="count(content/people[position()&gt;$from and position()&lt;$to])"/>
                    </xsl:attribute>
                    <xsl:for-each select="content/people[position()&gt;$from and position()&lt;$to]">
                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">Contact</xsl:attribute>
                            <xsl:attribute name="id">
                            <xsl:value-of select="name"/>
                            </xsl:attribute>

                            <xsl:element name="{$STRING}">
                               <xsl:attribute name="name">NickName</xsl:attribute>
                               <xsl:value-of select="name"/>
                            </xsl:element> 
                        </xsl:element>
                    </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                    <xsl:attribute name="quantity">
                            <xsl:value-of select="count(content/people)"/>
                    </xsl:attribute>

                    <xsl:for-each select="content/people">
                        <xsl:element name="{$STRUCT}">
                            <xsl:attribute name="name">Contact</xsl:attribute>
                            <xsl:attribute name="id">
                            <xsl:value-of select="name"/>
                            </xsl:attribute>

                            <xsl:element name="{$STRING}">
                               <xsl:attribute name="name">NickName</xsl:attribute>
                               <xsl:value-of select="name"/>
                            </xsl:element> 
                     
                        </xsl:element>
                    </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>

            </xsl:element> 
        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
