/*
 * config.h - methods and constants for driver
 * This file is part of MySocials driver library
 *
 * Copyright (C) 2010 - MySocials team
 *
 * libvkontakte library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libvkontakte library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libvkontakte library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _DRIVER_CONFIG_H_
#define _DRIVER_CONFIG_H_

#include <openssl/hmac.h>

//settings
#define DRIVER_ID "photobucket"
#define DRIVER_NAME "Photobucket"

#define DRIVER_PIC "iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAIAAAAlC+aJAAAAAXNSR0IArs4c6QAAAAlwSFlzAAAL\
EwAACxMBAJqcGAAAAAd0SU1FB9sFCwYiAX/0RDkAABQ7SURBVGjelVp5jF1ndf+d893Z7Fm8x0ts\
xzFJnODEWXCCUKEF00AgQkgJAcReBAVSaJGAFsQ/pbQVgRaU0gJKVZZUCWFpqoSlCTSFJCRkxQFn\
cezYjpeJl7E9M571vfudX/8433fvfTOOaJ+e3tx75937zvI7+5E/+PT9qgEaVINoAQ0iKhpEVUT9\
FCIiAqgAEAEA+CcAAgDJ9GkgQSONZrSIfEBGWn4zMpa0SCvz9ZJlSYuMpVlJK8nSykgraW2W0VjC\
r8fSot9empWFaJBQiFSfKhpEQuIkUa+AiAhECYHMZUBIoZEQGEnAYAYxUaEZJEIFJqjuNSC4LIhI\
CCBEAIRkEBAgjBIIKiQwUGKAEGJUFSNUAQW10FCIFiKFaEiC18KVABGRICJMnAAigjn0C9OBCkGa\
0kiFRqGSCokQgUUQCIIoCCUAGKAACQJWQgvXpASCwUUiYggBpIhBjKKQIGJQA5SmqlqIBpFCQpCg\
SQ+qIkn8VIWoiIjQqcc8BAlAAhCQYAAVZkohDRRQABEIIbRIwCIQABAkUCQlWls0gBQYlEAQEmIQ\
UlUQYM6SQgKVMBNVRJe9w0YLkeD4cR6gqiIQJgQ53TLPAghJ9Ig4VQiASjRIhEEUrG7weyMRiAho\
CQahgQEEVYUBgQTFFBIoJhpAo6pQKUmgUCUJ0YycUKgECQGSDADqmAfgJgCpqG9Sw8QDASFgcF5p\
YFCYW38ExF2AGwxCgOuhNApd9qQJApSgiShUSYduoh5UUpISxEQNVAdPIaIIQSSIBAa3BDjsoYl0\
qYwwq4BIsk+c+HlloAREKJAIAFC3UUggzFk1aCEgkBkwQpQaxAwSRA0MFBNRiLop0sGsCirFMmy0\
EAmYQ31FuqKJfkk0QzMvrP6wVk4+VgISndsggbAAOoQClYIAkKaigWZQCl385pjppF4hJqJEco9F\
Ar2oSMAc6hsakEyvzLeBLP7aSNhkoJMHJQgoQdJdiiigGegue6UGoZEq1qBeRUzh7lkla0A1mWzQ\
udRnwbsNJOo7GZDKjh1CzNDS7CgrHkgxAu7OlapCB49RVZISlKYQCpxogQqpIuLUUxVUiZY1IAUk\
CFTcXdYay/hBA0inM2K3XQpAiDnsAWvw4HeJhx4iEqpEEBrEIOp6oFiCtapYttoGcpIGKBCh+3VR\
iBROOkSd4eqNDJumC5ofB5x6xwU0m4HWPJBIWQhhohACQbISQGb6BKIUEVFLUV8y9SJQt1zCnyUG\
FQhFCoGIKlScSlFAKKozo8O0diad3UMrunt7PRo0nToq6l0JFEiwMs7OTMSJ42xN0YjQy+7FRc9g\
CN1AC9Eg4iiHGFWECqh7myRdivt7CuqLzoMIkgZEIIWrSZ00BQANMvHMz183+ORlL7ucycPLiVN7\
vm+vIQmBVhpIiKeIqBZTx1+Y2XVf//iejUvDuWuXr37JqqGhRT09ve326KlTzw8fG3/uaGv36IKR\
sKFYulGEbCRaVBVKAzBGyRIVc2FLDR6BSNaAYzzjRJQQLVon//T6v+gf6C9nJkMoQs+CODt15x3j\
M9oz34QlFKeeeww77njN+ctf/+43nrfpXd3d3XiRV4zx+T3P3v3AfXft7h5beGFIrjNIjJludahU\
0KIIVBG1FrwoER0bBcVzHTdNGm165y+Ksf0Q7D0y/pmbH2xPjv7jey4/a/36hePPHdt/sMMSPBPd\
+8A1rzjvrV/93MDAQDMKxNZMa3YGZHdPT+jugRQAQghnn3P+h845/09mpu+4+77v/Gp0dHSUtJxm\
pwNYSdIzbcQIM2FpDLH/zPz74qYir79xRHMY0CJM3PP5T779VVsuvuSMlatU9fDwoVa7veKMlb29\
vafGRkfHxqRTogQGhxYNDQ356fFjR7cPTz9xOO4bk9F2z4z1mElguw+t1f124criivVdZ69dlryq\
yOTEqZMnTzR0erpXFpjQvv7DB29/+AisZNk2i2C78ATZnQxFLl439Po3XO3FCcmVq9dUzxkYWjQw\
tGj+872Y2b13/+07Z5+YXDJdDtFMCEJIACjZPW3dx09y+4h86wlZ23PwLRfL6y5bBRQL+wcW9g/g\
//x687bZHz70X5qyAwOlcBYpKeb09Pb6V0+Mjs3Ozp5eIqFr1fIl1ens9OS3Hzx47/gZs2W/IKGU\
gEgBASMBc1aCQJTDM/3/cL/d9ujeT1/Vf876Va4KAMdGTrTbrUZszFZGDA0N9i9cgJy3C0Dx2IOi\
EV47ItTNj47dd3xIqpy0CgWqJx764Y3v2LrpgpcCOHL48JcemdnXXumpI7JLbY+PtB646cyVy6P2\
jrN/omcNVlzUXSwQREIKwfDMwIdvm/nw1qeuefUFzsMzhyY+9d3hQs3KNmNJa9NKi23GcjX33vbl\
j/b29tWpDFOALDC/RqmZMbcYssoJZOzp+/+ob/+mC94LYN/+gzc8EUbag5pqgpyZhjD762/e9NfX\
r1u/HkC73Ro5emT7bx+/+8mJJ8vNxcAaSinGoii++vCCIyce/sg1l5N85ZZ179w1fMvjTqJVKSIE\
J0aOxRgbJuE1ErLn54uDjh1Yb02Nr3j29k986q8AHD169Ivb5XjZI/NMkGZLz3rpuvVr/bSrq3vV\
mrVXXfWGL3/iuq9fGzbFh8oyUdOl+N7OxV/7/q9EhOT112w9b2mrAwxSZcCnf+lpae24kotGCcX4\
Pd/49Cc/3t3d3Z6Z+sojk8diXwJjVSH6y2zm3Kv/8vu7vnbP/lt+dfD+p14YGz3p/zn7Jef948eu\
/PMt+6w1UfFw61ODP/7vB0UEEj739vO88nxRqjrhUjhtjdK2kndHtgzB1OG92zb0btp0PoDvPbx/\
d3ulkJS6KEt8EoSI2a64/NlDsChGgdmWRc+/7/LejWvPIHn1tpeftXrXJ++cgnQB6CqKL/189uJz\
n1+zdv2Zq1devWXfndsnmqF+Ph/s0ABPz6unx4k+DTOP/eDd730fgAOHhu86sdzdZ7Ok9M/65yig\
KBBAhTxxYvD6O7u++qNdsDaBzeefc8Obuqxsp5v6ln3hlof81vdfudFoDcrJF4e3Mot6Lp9Mbyb0\
T1yypH3mmWcC+NHOyemoYrmeZBY8IZz7qPQYAkSh+PHzyz/+7d1xdgrAhZs2fOjlZTTvA8VHjy3d\
/pvHBFixYvnW9UWqLoTzhU/WTGnqzLATxA0lkBDK9J5Hr7pyG4DJsZMPjw4m2FsiLjcjck2Tixuy\
w5ZAUfCZiZWf+uYTjCXJa199/nmLJpyCrv7Ft9613X/3dZeuMieTc0RLgiJJVARVPOSirqeajGYx\
qBzeccmlLwPw9OGJU9ZLwvzL1kEuO4+bF5mVqYy/mzr7326/1+P/h7ctKyMAwuKj++PEqTGSl5+7\
7LS1aR37maFNGrMSOowYYCaO0DOKqUWLFwN48mhJM5yO4uS7mW70mqZSb7pCkgwSb9nRf2DfcwC2\
nHfmWQPTJEE7FVbsfPopEVmxbPHi3jLJda5kmYkDSAVMzGhM5M6zARjKVrlu6QK/vG+MwtwXyYRa\
EzaWDwBYOk1gSyAzkDqw+t9/8og7uW2b+x0w2rv4qZ3PAYAWqxYV9bNOY50NI04gYuKqfuXby9bs\
yqUp5To5o46f9G7wMB9CbHhkGGgmZkwtoPLB3TOt2VkAl24Y8MshhP2HT/gPLRvs9nY3m8AQJMCD\
3spUmoFRaGRSQqUoA2gwg7XLgYV9nuRPlwqTpgYqHlzeHdCKYPTrJClmTEoxMo5y6OCB5wGsW9YT\
xLx8Hjs16QT0dqkl9TXATTROCVK16CJIs4Ts02kA1K6urpwcChMN6Z1JglVoqajPcCWFNMLI9IZZ\
LAZfGD4EoK+3p1tK0sAYc5ZRKZFzgZF+wzWhsTXlpRCch7lfS0nE9GwJAAh9GmuDyRA3a5gpMleN\
L9BMorNotMxD0Tc2NupeJQhBs7Ls6UpZwsR0y/uNINl0o/UVA1nQDGJgBCAWa2UZaKnDqaH7xKQz\
gCV9um8a4plq9eBGDHa6USk/QT+SMdHNiBhJ616w6K7nxjYfGP7PXx+YbAvNytb0yrUL/ZEj4zNJ\
0rC5SSUo2XQLWszJn5Cxw1lZ6vYIw6Hx9IiNS8Ojx0WbRKOO2cl1WnY7TerRGDQl2yq3j57xzpsO\
WYxiJWk2eXjDWesAlLPTh0fbzBpoMpBTB/f+VFqEGWOaXnVmxdU7HprqL8sSwEWrihjFKtAbGOuD\
+tNc4iYxyz6NxqpTf0SElZJOGcb3bLpgM4ADh0fGplHhbU6aSZgbB0mlWZZKSYu1TGn+fEay5Imu\
DYf27wWwee1QP6YqAjK5aLLkSKQZnFzLTQc/jax/zvJ/aUau7ho5++yNAB7beaRdlqxdBBv5pUme\
IwKmtLL59AafhugjRFhEWHbBvQ//DoB09V65IVoUxpp6pGOmTxqit0bKumWSqK/klXSErJ/W8T1v\
+MMtIQQAP33kgMJgldfqTHEyfkAoGS1WPJQ12oxkRIyIJS0G4O5n1SySfOvWQS1bySCNGUJOfXVL\
mX67ElAH9bHxBVcUB088cO1b3gZg9559Ow61kIMGO71QBWu/XX1SazFamto26kKLZDRvM5Xt4Z6L\
H/z1QyLSPzj0ni1T7VJSD8oio7ef8iiX1SS4tBh9uFvBJn1Ga4yNrTX82Hvf/MolS5YA+NZPn2y3\
yjpizLUBqzVg1KzcNEBuQohOTfqNsrun76Zfjltsk7z2les2DxyBlYglYqLbrKSZsTGsjqU/udF7\
Kxtw8jl2bE8cvWRg3zve9R4AO57e9fMnJwQRrHt1nV4ohR73UUqz5i81jJiMpcW2tzf8+GCx+dY7\
7xMRIPztdWuWyDGypJlZNKfMvCOSRR5Lxmg0lmW+Hummlew7ljMTK0d+8nef/5uiKFqz03//3d+2\
Wq1a9nG+FzLSmLGkjG0yZjmVFasxRkefZ2x+hyq++dSqZ559DkDfwoGvvXvVEI+ZbwPEkrFtsVKF\
M5/wk9hz0mnpwGI5dXLp8A++csPnVqxYAfKGm+996oV2irekUVI+VudCrJIGmhFWZN9fQACU0PTV\
P76g79Djt1VNouZg+657Vm06dyOAwUVLvvE+++hNTw9zjTIyx2EHaOXsCWOM2SKzuzO2xobXj//s\
n/75S6tXryYZzRZy7IqFO/K8sIpfHOhbEUJuIppRmO2YRYINCQ2Epiqf3Hrhxq1f+MzvbVYuWrzs\
Xz966Rdv/sVd+5d3LxhEjjvJQyHzYJGg+yiSZbsVD/zyVetbn/3CjW64IlKE8PEPXAdc93t+0ozC\
KjUsPLKIUkARmYh9nRL//a+evoWf/eAbr97+m3+547EnR5cVg6tU3F0mZ+f25LppTY7i6G/OWfDC\
B65/26tfsw3/z9fuvQdTym7JBcsVH7uj3utQJeTK87uXLe73bmgeSYpveuTRtlRx8bUXLdm0oW7Q\
PvvMjp/+8vFHdo8dGsMM+kx7SKKckdmx7vbI8p7pl1+wattrX3vJpZepKoDpyVO3/mzH+FTbd1zI\
RqrMynxTRnRybPzH9++cmpnNuzaRjHL5n/2HSJAQ0lxEA/Kk0uf9AqT1hMasr1JQGfmmzXr91ef2\
Dww2RTU+Nnp85Njo6MlWq10UxeDQomXLli9avLjWLeM9D+648c5d+0dmG6EtJq9oMa0PMaJeLooJ\
jVZaumiy9SO3+a4NfM/JSaz3nPJyRdp5as5Z6z54wfimixdc84rV69as/L0wODV28t7t+275nz07\
D5eMJSwSOTBXoS2FCEOKfe6RE2/G9F+LUS774C1p0UaDqC/kaDUSTBO0xEma7eTJfUd2QjAazhoq\
rzhn6KINQ2ctX7hkoLu3pwDQbpdjk63DJ6aeOTD6yDNHfndoZnyyFCSPBA/bzZzPMvWVZjzny0te\
Zubxhxbl0vd/x/GTqNc89M5sVLtaNensnJMxzSGqFDd6bqyiQoVFY4wxxpTx5fq7CrRlik0x1utn\
NfX1lQZ4Km7LgixREkHJvB1iiQdmwZMiMKs63fN9VK4yfFIVUnVkESyZkkpJBzSvQFCN9AxVtmdV\
udM4jZGks2epQmCVRRa0kkKJKuK7Lcx7FHlK7jz40BlC90Wn77WmCAZWBUcKN0i/GuuCOJc1dVKd\
aLUEqoqHVMp5KyDCPBJHl0thsRQ1SIAoaSLBt0Dq+Xh2QXm83DlwYN7dq9oHVY8pMYCqDcFGGuzB\
uII+KtlX0RqZn6Z+PMDn8ppmBWMJBijznof5nlQeMvvw2WObwK1CgOT36w54vX+Z+zaNkMwm6SnF\
Z/REjQ3SUVkzG1iKVWbqppy+kDRAKwkKK9xXdCuh1WQcvgbRWBplMz9i1TbMze+UDnl4avKQszEP\
1VaLU9JxTNVCQ/ZmuRalEQbE1ARKEKIhISdtKopYtVmRd0QkO6V6wNbc+6saiKzOUxytcjvWQKqg\
b1XJkqv+yjDMkFx+Vc2lDkJlSJ6NlqBCM3I0CH2M7JbgAcE3fqTWgFRzyY7pCJsayF61w5qrMtJS\
qpcCgkvUKnA3Ng/YUEjlbUki0qyARe8SiRhUYQatF3iQzTct8LBKr6VRJQmbrZuEnLp1QxhsDg8k\
TZgXk2GpXCZR0131kdhJfXZopCAWtLZHXyYvlFYbq02RbABVFpQNoEF/RbnUE6vKmo2WgWTm/5DK\
pi0ydR/obWZGI6LRGCPqpm2T+tT/8G5SYVaKJDcqIpbM1xqLLTkRSkCCuEGjubTi0yxmCOXKtRGe\
PThINuhkAF4wZH/qlFlVCWVjqF1Ws3tjkbSCZQlVqokooFCHjVpKJcyzUdbSVwpB1wmrpn1zXplL\
s3SQ6AYbDYVsCUnwlr07c8wiYvRSrtHoY5N6L+0Ljw5SQZ/VqndCP0XBKBWKEKVzC6Z2ox3b+AQo\
rG16XlhgUwl1jwiWYVNZgmXs5f5Zo53+v+HD874///LFAAAAAElFTkSuQmCC"

#define CONSUMER_SECRET "7a43638cb7336333990c703f1a91343b"
#define NOT_ESCAPE "!\"$%&'()*+,-.0123456789;<=:>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~"

#define NOT_ESCAPE2 "!\"$'()*,-.0123456789;<>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~"

#define RESPONSE_EMPTY "<?xml version=\"1.0\"?><response></response>"

#define LOGIN_SUCCESS "^http://photobucket.com/apilogin/done.*"

#define AUTH_REQUEST "<Request class='system' function='getOauthToken'><Params/></Request>"

#define MSG_AUTH_ERROR "<error><error_code>1"DRV_AUTH_ERROR_CODE"</error_code>\
                              <error_msg>"DRV_AUTH_ERROR"</error_msg></error>"

#define MSG_NETWORK_ERROR "<error><error_code>1"DRV_NETW_ERROR_CODE"</error_code>\
                              <error_msg>"DRV_NETW_ERROR"</error_msg></error>"

#define MSG_NETWORK_SERVER_ERROR "<error><error_code>1"DRV_SERVER_ERROR_CODE"</error_code>\
                              <error_msg>"DRV_SERVER_ERROR"</error_msg></error>"

#define MSG_AUTH_SUCCESS "<response>authorized</response>"

#define MSG_INFO "<info></info>"

#define MSG_SETTINGS_SAVED_ERROR "<error><error_code>1"DRV_SETT_ERROR_CODE"</error_code>\
                              <error_msg>"DRV_SETT_ERROR"</error_msg></error>"

#define MSG_FILE_SAVE_ERROR "<error><error_code>1"DRV_FILE_SAVE_ERROR_CODE"</error_code>\
                              <error_msg>"DRV_FILE_SAVE_ERROR"</error_msg></error>"

#define NOT_USE_DEFAULT_WEBAUTH_PARSER
#define NOT_USE_DEFAULT_TEXT_PARSER
#define NOT_USE_DEFAULT_PROCESS_URL
#endif
