#!/bin/bash

if [ $1 == "" ]; then
    echo "Must specify target platform"
    exit
fi

#SVN_LOC=http://uv-desktop/svn/home/external/mosquitto
SVN_LOC=http://192.168.15.50/svn/home/external/mosquitto
MQVER=0.9.3
SVNVER=`svn log $SVN_LOC --limit=1 | grep '^r' | sed 's/^r\([0-9]*\).*/\1/'`

rm build-stamp configure-stamp
rm -rf ./mosquitto*
rm -rf ./libmosquitto*

svn export $SVN_LOC libmosquittopp-$MQVER.$SVNVER
pushd libmosquittopp-$MQVER.$SVNVER
echo y | dh_make --createorig --single -e yuvraaj@gmail.com -c lgpl

# First create everything for libmosquittopp
cp build-files/libmosquittopp.control debian/control
cp build-files/libmosquittopp.rules debian/rules
cp build-files/libmosquittopp.install debian/

head -1 ./debian/changelog >dest.txt ; cat ./build-files/changelog >>dest.txt ; tail -2 ./debian/changelog | head -1 | sed 's/unknown/Yuvraaj Kelkar/g' >>dest.txt
mv dest.txt ./debian/changelog

dpkg-buildpackage -rfakeroot -sa -S
dput -f $1-extras-builder ../libmosquittopp*.changes
#dpkg-buildpackage -rfakeroot

popd

