#!/bin/bash

if [ $1 == "" ]; then
    echo "Must specify target platform"
    exit
fi

#SVN_LOC=http://uv-desktop/svn/home/external/mosquitto
SVN_LOC=http://192.168.15.50/svn/home/external/mosquitto
SVNVER=`svn log $SVN_LOC --limit=1 | grep '^r' | sed 's/^r\([0-9]*\).*/\1/'`

rm build-stamp configure-stamp
rm -rf ./mosquitto*
rm -rf ./libmosquitto*

svn export $SVN_LOC libmosquitto-0.9.1.$SVNVER
pushd libmosquitto-0.9.1.$SVNVER
echo y | dh_make --createorig --single -e yuvraaj@gmail.com -c lgpl

# First create everything for libmosquitto
cp build-files/libmosquitto.control debian/control
cp build-files/libmosquitto.rules debian/rules
cp build-files/libmosquitto.install debian/
dpkg-buildpackage -rfakeroot -sa -S
dput -f $1-extras-builder ./libmosquitto*.changes
#dpkg-buildpackage -rfakeroot

popd

