
#include <microfeed-provider/microfeederror.h>
#include <microfeed-common/microfeedmisc.h>

#include <string.h>

struct _MicrofeedError {
	char* name;
	char* message;	
};

MicrofeedError* microfeed_error_new(const char* name, const char* message) {
	MicrofeedError* error;
	
	error = microfeed_memory_allocate(MicrofeedError);
	error->name = (name ? strdup(name) : NULL);
	error->message = (message ? strdup(message) : NULL);

	return error;
}

void microfeed_error_free(MicrofeedError* error) {
	free(error->name);
	free(error->message);
	microfeed_memory_free(error);
}

const char* microfeed_error_get_name(MicrofeedError* error) {
	
	return error->name;
}

const char* microfeed_error_get_message(MicrofeedError* error) {
	
	return error->message;
}
