#ifndef MICROFEEDCONFIGURATION_H
#define MICROFEEDCONFIGURATION_H

/**
 * @addtogroup MicrofeedConfiguration
 * 
 * This module implementing an easy access to provider and publisher configuration is usually used both in
 * the publisher and in the subscriber side.
 * 
 * @link MicrofeedProvider MicrofeedProvider@endlink and @link MicrofeedSubscriber MicrofeedSubsciber@endlink
 * require configuration to locate existing publishers before instantiating or creating a
 * @link MicrofeedPublisher MicrofeedPublisher@endlink.
 *
 * @{
 */

/**
 * Opaque data type representing configuration.
 */
typedef struct _MicrofeedConfiguration MicrofeedConfiguration;

MicrofeedConfiguration* microfeed_configuration_new();
void microfeed_configurtion_free(MicrofeedConfiguration* configuration);
void microfeed_configuration_invalidate(MicrofeedConfiguration* configuration);
const char* microfeed_configuration_get_application_identifier(MicrofeedConfiguration* configuration);
const char** microfeed_configuration_get_providers(MicrofeedConfiguration* configuration);
const char* microfeed_configuration_get_provider_name(MicrofeedConfiguration* configuration, const char* provider_identifier);
const char** microfeed_configuration_get_publishers(MicrofeedConfiguration* configuration);
const char* microfeed_configuration_get_publisher_directory(MicrofeedConfiguration* configuration, const char* publisher_identifier);
const char* microfeed_configuration_get_default_publisher_directory(MicrofeedConfiguration* configuration);
const char** microfeed_configuration_get_providers_predefined_feed_uris(MicrofeedConfiguration* configuration, const char* provider_identifier);
const char** microfeed_configuration_get_subscriptions(MicrofeedConfiguration* configuration, const char* application_identifier);
void microfeed_configuration_add_subscription(MicrofeedConfiguration* configuration, const char* application_identifier, const char* publisher_identifier);
void microfeed_configuration_remove_subscription(MicrofeedConfiguration* configuration, const char* application_identifier, const char* publisher_identifier);

/** @} */

#endif
