#include "period.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define ARRAY_TO_LIST(tp, str) \
if (rul_->tp) { \
if (!first) buf << ";"; \
    buf << str; \
for (int i = 0; i < rul_->tp->len; i++) { \
    if (i != 0) \
    buf << ","; \
    short day = g_array_index(rul_->tp, short, i); \
    buf << day; \
} \
first = false; \
}

#ifdef GLIB_MODE
#define DELETE_ARRAY(field) \
    if(rul_->field) {\
        g_array_free(rul_->field, TRUE); \
        rul_->field = NULL; \
    }
#else
#define DELETE_ARRAY(field) \
    if(rul_->field) {\
        free(rul_->field); \
        rul_->field = NULL; \
    }
#endif

#ifdef GLIB_MODE
static GArray* array_libical_to_kimi(short* arr, int max_size)
#else
static short* array_libical_to_kimi(short* arr, int max_size)
#endif
{
    int i;
    if (!arr) {
        g_critical("Function array_kimi_to_libical shouldn't get NULL value");
        return NULL;
    }

    /* If libical array empty */
    if (arr[0] == ICAL_RECURRENCE_ARRAY_MAX) {
        return NULL;
    }

#ifdef GLIB_MODE
    GArray* ret = g_array_new(TRUE, TRUE, sizeof(short));
    for (i = 0; arr[i] != ICAL_RECURRENCE_ARRAY_MAX && i < max_size; i++) {
        g_array_append_val(ret, arr[i]);
    }
#else
    int size = 0;
    for (i = 0; arr[i] != ICAL_RECURRENCE_ARRAY_MAX; i++) {

    }
    size = i;
    short* ret = calloc(size + 1, sizeof(short));
    memcpy(ret, arr, sizeof(short) * (size + 1));
    ret[size] = '\0';

#endif
    return ret;

}
#ifdef GLIB_MODE
static void array_kimi_to_libical(short* dest, GArray* src, int max_size)
#else
static void array_kimi_to_libical(short* dest, short* src, int max_size)
#endif
{
    int i = 0;
    if (src) {
#ifdef GLIB_MODE
        for (i = 0; i < src->len; i++) {
#else
        for (i = 0; src[i] != '\0'; i++) {
#endif
            if (i == max_size) {
                g_error("array_kimi_to_libical: too long array");
            }
#ifdef GLIB_MODE
            dest[i] = g_array_index(src, short, i);
#else
            dest[i] = src[i];
#endif
        }
    }

    if (i < max_size) {
        dest[i] = ICAL_RECURRENCE_ARRAY_MAX;
    }
}

Rule* kimi_per_create_rule_from_ical(const char* ical, int type, int wkst)
{
    Rule* rul = kimi_per_create_rule(type, REC_DAY, wkst);
    if (!rul)
        return NULL;

    kimi_per_set_ical(rul, ical);

    rul->wkst = wkst; 
    return rul;
}

Rule* kimi_per_create_rule(int type, PerType freq, int wkst)
{
    Rule* rul = (Rule*) calloc(1, sizeof(Rule));
    if (!rul) 
        return NULL;

    rul->interval = rul->count = rul->until = 0;
    
    rul->freq = freq;
    rul->wkst = wkst; 

    return rul;
}

void kimi_per_convert_kimi_to_libical_rule(struct icalrecurrencetype* libical_rule,
                                           Rule* kimi_rule)
{
    icalrecurrencetype_clear(libical_rule);

    libical_rule->freq = (icalrecurrencetype_frequency) kimi_rule->freq;
    libical_rule->until = kimi_rule->until != 0 ? icaltime_from_timet(kimi_rule->until, 1) : icaltime_null_time();
    libical_rule->count = kimi_rule->count;
    libical_rule->interval = kimi_rule->interval;

    array_kimi_to_libical(libical_rule->by_second, kimi_rule->seconds, ICAL_BY_SECOND_SIZE);
    array_kimi_to_libical(libical_rule->by_minute, kimi_rule->minutes, ICAL_BY_MINUTE_SIZE);
    array_kimi_to_libical(libical_rule->by_hour, kimi_rule->hours, ICAL_BY_HOUR_SIZE);
    array_kimi_to_libical(libical_rule->by_day, kimi_rule->week_days, ICAL_BY_DAY_SIZE);
    array_kimi_to_libical(libical_rule->by_month_day, kimi_rule->month_days, ICAL_BY_MONTHDAY_SIZE);
    array_kimi_to_libical(libical_rule->by_year_day, kimi_rule->year_days, ICAL_BY_YEARDAY_SIZE);
    array_kimi_to_libical(libical_rule->by_week_no, kimi_rule->week_number, ICAL_BY_WEEKNO_SIZE);
    array_kimi_to_libical(libical_rule->by_month, kimi_rule->months, ICAL_BY_MONTH_SIZE);
    array_kimi_to_libical(libical_rule->by_set_pos, kimi_rule->set_pos, ICAL_BY_SETPOS_SIZE);

    libical_rule->week_start = kimi_rule->wkst + 1;
}

void kimi_per_convert_libical_to_kimi_rule(Rule* kimi_rule,
                                           struct icalrecurrencetype* libical_rule)
{
    kimi_per_clear_rule(kimi_rule);

    kimi_rule->freq = libical_rule->freq;
    kimi_rule->until = icaltime_as_timet(libical_rule->until);
    kimi_rule->count = libical_rule->count;
    kimi_rule->interval = libical_rule->interval;

    kimi_rule->seconds = array_libical_to_kimi(libical_rule->by_second, ICAL_BY_SECOND_SIZE);
    kimi_rule->minutes = array_libical_to_kimi(libical_rule->by_minute, ICAL_BY_MINUTE_SIZE);
    kimi_rule->hours = array_libical_to_kimi(libical_rule->by_hour, ICAL_BY_HOUR_SIZE);
    kimi_rule->week_days = array_libical_to_kimi(libical_rule->by_day, ICAL_BY_DAY_SIZE);
    kimi_rule->month_days = array_libical_to_kimi(libical_rule->by_month_day, ICAL_BY_MONTHDAY_SIZE);
    kimi_rule->year_days = array_libical_to_kimi(libical_rule->by_year_day, ICAL_BY_YEARDAY_SIZE);
    kimi_rule->week_number = array_libical_to_kimi(libical_rule->by_week_no, ICAL_BY_WEEKNO_SIZE);
    kimi_rule->months = array_libical_to_kimi(libical_rule->by_month, ICAL_BY_MONTH_SIZE);
    kimi_rule->set_pos = array_libical_to_kimi(libical_rule->by_set_pos, ICAL_BY_SETPOS_SIZE);

    kimi_rule->wkst = libical_rule->week_start - 1;
}


const char* kimi_per_get_ical(Rule* rul)
{
    struct icalrecurrencetype rec;
    kimi_per_convert_kimi_to_libical_rule(&rec, rul);
    return icalrecurrencetype_as_string_r(&rec);
}

void kimi_per_set_ical(Rule* rul, const char* ical)
{
    kimi_per_clear_rule(rul);
    struct icalrecurrencetype rec = icalrecurrencetype_from_string(ical);
    kimi_per_convert_libical_to_kimi_rule(rul, &rec);
}

void kimi_per_free_rule(Rule* rul_)
{  
    kimi_per_clear_rule(rul_); 
    free(rul_);
}

void kimi_per_clear_rule(Rule* rul_)
{   
    DELETE_ARRAY(seconds);
    DELETE_ARRAY(minutes);
    DELETE_ARRAY(hours);
    DELETE_ARRAY(week_days);
    DELETE_ARRAY(month_days);
    DELETE_ARRAY(year_days);
    DELETE_ARRAY(week_number);
    DELETE_ARRAY(months);
    DELETE_ARRAY(set_pos);
    memset(rul_, 0, sizeof(Rule));
}

Period* kimi_per_dup(Period* per)
{
    int i;
    if (!per)
        return NULL;

    Period* ret = kimi_per_create_period();

    for (i = 0; i < per->len; i++) {
        Rule* rul = per->pdata[i];
        g_ptr_array_add(ret, kimi_per_create_rule_from_ical(kimi_per_get_ical(rul), rul->type, rul->wkst));
    }
    return ret;
}

void kimi_per_free_period(Period* per)
{
    int i;
    for (i = 0; i < per->len; i++) {
        kimi_per_free_rule((Rule*)g_ptr_array_index(per, i));
    }
    g_ptr_array_free(per, TRUE);
}

void kimi_per_merge_arrays(GArray* dest, GArray* src)
{
    int i, j;
    int* flags = calloc(src->len, sizeof(int));
    for (i = 0; i < src->len; i++) {
        for (j = 0; j < dest->len; j++) {
            if (icaltime_compare_date_only(g_array_index(dest, struct icaltimetype, j),
                                           g_array_index(src, struct icaltimetype, i)) == 0) {
                flags[i] = 1;
                break;
            }
        }
    }
    
    for (i = 0; i < src->len; i++) {
        /* Date src[i] not in dest array */
        if (!flags[i]) {
            g_array_append_val(dest, g_array_index(src, struct icaltimetype, i));
        }
    }
    free(flags);
}

GArray* kimi_per_generate_rule_instance_times(Rule* rul, time_t begin, time_t end, 
                                       time_t event_time)
{
    GArray* ret = g_array_new(TRUE, TRUE, sizeof(struct icaltimetype));
    struct icaltimetype begin_ical = icaltime_from_timet(begin, 1);
    struct icaltimetype end_ical = icaltime_from_timet(end, 1);
    struct icaltimetype event_ical = icaltime_from_timet(event_time, 1);
    struct icaltimetype next;

    struct icalrecurrencetype rec;
    
    kimi_per_convert_kimi_to_libical_rule(&rec, rul);
    
    icalrecur_iterator* ritr;
    ritr = icalrecur_iterator_new(rec, event_ical);

    int event_time_in_period = 0;
    while (!icaltime_is_null_time(next = icalrecur_iterator_next(ritr))) {
        if (icaltime_compare_date_only(next, event_ical) == 0) {
            event_time_in_period = 1;
        }
        
        if (icaltime_compare_date_only(next, end_ical) > 0) {
            break;
        }
        
        if (icaltime_compare_date_only(next, begin_ical) >= 0) {
            g_array_append_val(ret, next);
        }
    }
    if (!event_time_in_period && icaltime_compare_date_only(event_ical, begin_ical) >= 0) {
        g_array_append_val(ret, event_ical);
    }

    icalrecur_iterator_free(ritr);
    return ret;
}

static int compare_ical_dates(gconstpointer a, gconstpointer b)
{
    struct icaltimetype* ta = (struct icaltimetype*) a;
    struct icaltimetype* tb = (struct icaltimetype*) b;

    return icaltime_compare_date_only(*ta, *tb);
}

GArray* kimi_per_generate_instance_times(Period* per, time_t begin, time_t end, time_t event_time)
{
    int i;
    struct icaltimetype begin_ical = icaltime_from_timet(begin, 1);
    struct icaltimetype end_ical = icaltime_from_timet(end, 1);
    struct icaltimetype event_ical = icaltime_from_timet(event_time, 1);
    
    GArray* ret = g_array_new(FALSE, FALSE, sizeof(struct icaltimetype));
    if (per) {
        for (i = 0; i < per->len; i++) {
            Rule* rul = (Rule*) g_ptr_array_index(per, i);
            
            GArray* rule_instances = kimi_per_generate_rule_instance_times(rul, begin, end, event_time);
            kimi_per_merge_arrays(ret, rule_instances);
            g_array_free(rule_instances, TRUE);
        }
    }
    /* Add real event to array */
    if (icaltime_compare_date_only(event_ical, begin_ical) >= 0
        && icaltime_compare_date_only(event_ical, end_ical) <= 0) {
        int flag = 0;

        for (i = 0; i < ret->len; i++) {
            if (icaltime_compare_date_only(event_ical, g_array_index(ret, struct icaltimetype, i)) == 0) {
                flag = 1;
                break;
            }
        }
    
        if (flag == 0) {
            g_array_append_val(ret, event_ical);
        }
    }
    g_array_sort(ret, compare_ical_dates);
    GArray* ret_time_t = g_array_new(FALSE, FALSE, sizeof(time_t));
    for (i = 0; i < ret->len; i++) {
        time_t t = icaltime_as_timet(g_array_index(ret, struct icaltimetype, i));
        g_array_append_val(ret_time_t, t);
    }
    g_array_free(ret, TRUE);
    return ret_time_t;
}

time_t kimi_per_get_time_t(const char* str)
{
    return icaltime_as_timet(icaltime_from_string(str));
}

