/*
 * This file is part of libimagecache
 *
 * Copyright (C) 2010 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _IMAGE_CACHE_H
#define _IMAGE_CACHE_H

#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define IMAGE_CACHE_TYPE		(image_cache_get_type ())
#define IMAGE_CACHE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), IMAGE_CACHE_TYPE, ImageCache))
#define IMAGE_CACHE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), IMAGE_CACHE_TYPE, ImageCacheClass))
#define IS_IMAGE_CACHE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), IMAGE_CACHE_TYPE))
#define IS_IMAGE_CACHE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), IMAGE_CACHE_TYPE))
#define IMAGE_CACHE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), IMAGE_CACHE_TYPE, ImageCacheClass))

/**
 * ImageCache
 */
typedef struct _image_cache ImageCache;
struct _image_cache {
	GObject parent;
	GHashTable *cache;
	GMutex *mutex;
	guint hit;
	guint miss;
	guint drop;
	guint error;
	guint cache_max;
	guint gc;
	gfloat avgs;
	gboolean cache_errors;
	time_t last_get;
	gpointer priv;
};

typedef struct _image_cache_Class ImageCacheClass;
struct _image_cache_Class {
	GObjectClass parent;
	void (*image_loaded) (ImageCache *ic, gpointer key, gpointer data);	
};

GType image_cache_get_type(void);

ImageCache *image_cache_new(guint cache_max, gboolean ce);
ImageCache *image_cache_new_full(guint cache_max, gboolean ce, GHashFunc hash_func, GEqualFunc key_equal_func);

void image_cache_clear(ImageCache *ic);
void image_cache_set_size(ImageCache *ic, guint cache_size);
void image_cache_gc(ImageCache *ic, guint max);
gboolean image_cache_invalidate(ImageCache *ic, gpointer key);
void image_cache_invalidate_by_image(ImageCache *ic, GdkPixbuf *pixbuf);
void image_cache_print_stats(ImageCache *ic);

gboolean image_cache_load_file(ImageCache *ic, gpointer key, const gchar *image, GError **err, gpointer user_data);
GdkPixbuf *image_cache_get(ImageCache *ic, gpointer key);

void image_cache_put(ImageCache *ic, gpointer key, GdkPixbuf *pixbuf, gpointer user_data);
void image_cache_replace(ImageCache *ic, gpointer key, GdkPixbuf *pixbuf, gpointer user_data);

G_END_DECLS

#endif
