/*
 * This file is a part of hildon-extras
 *
 * Copyright (C) 2009 Andrew Olmsted
 * Copyright (C) 2005, 2008 Nokia Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __HE_MENU_STORE_H__
#define __HE_MENU_STORE_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define HE_TYPE_MENU_STORE (he_menu_store_get_type())
#define HE_MENU_STORE(object)           (G_TYPE_CHECK_INSTANCE_CAST((object), HE_TYPE_MENU_STORE, HeMenuStore))
#define HE_MENU_STORE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass),     HE_TYPE_MENU_STORE, HeMenuStoreClass))
#define HE_IS_MENU_STORE(object)        (G_TYPE_CHECK_INSTANCE_TYPE((object), HE_TYPE_MENU_STORE))
#define HE_IS_MENU_STORE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE((klass),     HE_TYPE_MENU_STORE))
#define HE_MENU_STORE_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS((object),  HE_TYPE_MENU_STORE, HeMenuStoreClass))

typedef struct _HeMenuStore      HeMenuStore;
typedef struct _HeMenuStoreClass HeMenuStoreClass;

GType he_menu_store_get_type(void);

GtkTreeModel *he_menu_store_new(GtkMenu *menu);

typedef enum {
//HE_MENU_STORE_IMAGE_GICON,
//HE_MENU_STORE_IMAGE_ICON_NAME,
	HE_MENU_STORE_IMAGE_PIXBUF,
//HE_MENU_STORE_IMAGE_STOCK_ID,
//HE_MENU_STORE_IMAGE_ICON_SIZE,
	HE_MENU_STORE_IS_IMAGE_ITEM,
	HE_MENU_STORE_IS_CHECK_ITEM,
	HE_MENU_STORE_IS_RADIO_ITEM,
	HE_MENU_STORE_TEXT,
	HE_MENU_STORE_VISIBLE,
	HE_MENU_STORE_SENSITIVE,
	HE_MENU_STORE_ACTIVE,
	HE_MENU_STORE_INCONSISTENT,
//HE_MENU_STORE_ACCEL,
	HE_MENU_STORE_MENU_WIDGET,
	HE_MENU_STORE_HAS_CHILDREN,
	HE_MENU_STORE_N_COLUMNS
} HeMenuStoreColumn;

G_END_DECLS

#endif /* !__HE_MENU_STORE_H__ */
