/*
 * This file is a part of hildon-extras
 *
 * Copyright (C) 2010 Gabriel Schulhof <nix@go-nix.ca>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __HE_MENU_VIEW_H__
#define __HE_MENU_VIEW_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define HE_TYPE_MENU_VIEW (he_menu_view_get_type())
#define HE_MENU_VIEW(object)           (G_TYPE_CHECK_INSTANCE_CAST((object), HE_TYPE_MENU_VIEW, HeMenuView))
#define HE_MENU_VIEW_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass),     HE_TYPE_MENU_VIEW, HeMenuViewClass))
#define HE_IS_MENU_VIEW(object)        (G_TYPE_CHECK_INSTANCE_TYPE((object), HE_TYPE_MENU_VIEW))
#define HE_IS_MENU_VIEW_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE((klass),     HE_TYPE_MENU_VIEW))
#define HE_MENU_VIEW_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS((object),  HE_TYPE_MENU_VIEW, HeMenuViewClass))

typedef struct _HeMenuView        HeMenuView;
typedef struct _HeMenuViewClass   HeMenuViewClass;
typedef struct _HeMenuViewPrivate HeMenuViewPrivate;

struct _HeMenuView
{
	GtkFixed __parent_instance__;
	HeMenuViewPrivate *priv;
};

struct _HeMenuViewClass
{
	GtkFixedClass __parent_class__;
};

GType he_menu_view_get_type(void) G_GNUC_CONST;

GtkWidget *he_menu_view_new(void);

void he_menu_view_set_menu(HeMenuView *hmv, GtkMenu *menu);
GtkWidget *he_menu_view_get_menu(HeMenuView *hmv);
GtkWidget *he_menu_view_get_menu_widget(HeMenuView *hmv);
void he_menu_view_set_do_activate(HeMenuView *hmv, gboolean do_activate);
gboolean he_menu_view_get_do_activate(HeMenuView *hmv);
void he_menu_view_popup(GtkMenu *menu, GtkWindow *parent);

void he_menu_view_handle_hildon_windows(void);

G_END_DECLS

#endif /* !__HE_MENU_VIEW_H__ */
