<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/">
 <xsl:apply-templates select="/data/rsp[@stat='ok']"/>
 <xsl:apply-templates select="/data/rsp[@stat='fail']"/>
</xsl:template>

<xsl:template match="rsp[@stat='ok']">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photo</xsl:attribute>
        <xsl:attribute name="function">uploadPhoto</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">photoId</xsl:attribute>
                <xsl:text>fl</xsl:text>
                <xsl:value-of select="photoid"/>
            </xsl:element>

        <xsl:choose>

            <xsl:when test="/data/Request/Params/string[@name = 'albumId']">
                <xsl:element name="{$REQUEST}">
                    <xsl:attribute name="class">photos</xsl:attribute>
                    <xsl:attribute name="function">addPhoto</xsl:attribute>
                    <xsl:element name="{$PARAMS}">
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">albumId</xsl:attribute>
                            <xsl:value-of select="/data/Request/Params/string[@name = 'albumId']"/>
                        </xsl:element>
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">photoId</xsl:attribute>
                            <xsl:text>fl</xsl:text>
                            <xsl:value-of select="photoid"/>
                        </xsl:element>
                    </xsl:element> 
                </xsl:element>
            </xsl:when>

            <xsl:otherwise>
                <xsl:element name="{$REQUEST}">
                    <xsl:attribute name="class">photos</xsl:attribute>
                    <xsl:attribute name="function">createAlbum</xsl:attribute>
                    <xsl:element name="{$PARAMS}">
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">name</xsl:attribute>
                            <xsl:value-of select="/data/Request/Params/string[@name = 'albumName']"/>
                        </xsl:element> 
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">description</xsl:attribute>
                            <xsl:value-of select="/data/Request/Params/string[@name = 'albumDescription']"/>
                        </xsl:element>
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">photoId</xsl:attribute>
                            <xsl:text>fl</xsl:text>
                            <xsl:value-of select="photoid"/>
                        </xsl:element>
                    </xsl:element> 
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>

        </xsl:element>
    </xsl:element> 
</xsl:template>
</xsl:stylesheet>
